# Конфігурація FLOWAXY-CMS

Детальний опис конфігураційних файлів та налаштувань системи.

## Структура конфігурацій

Всі конфігураційні файли зберігаються в `storage/config/`:

```
storage/config/
├── system/              # Системні конфігурації
│   ├── app.ini         # Налаштування додатку
│   ├── cache.ini       # Налаштування кешу
│   ├── database.ini    # Налаштування БД
│   ├── security.ini    # Налаштування безпеки
│   ├── logging.ini     # Налаштування логування
│   ├── plugins.ini     # Статуси плагінів
│   └── themes.ini      # Статуси тем
├── plugins/            # Налаштування плагінів
│   └── {plugin-slug}.ini
├── themes/             # Налаштування тем
│   └── {theme-slug}.ini
├── flowaxy/            # Конфігурації ядра
│   └── services.json   # Конфігурація DI контейнера
└── site.php            # Налаштування сайту
```

## Системні конфігурації

### app.ini

Налаштування додатку:

```ini
[app]
name = "Flowaxy CMS"
version = "0.0.3"
environment = "production"
debug = false
timezone = "Europe/Kyiv"
locale = "uk_UA"
```

**Параметри:**

-   `name` — назва додатку
-   `version` — версія системи
-   `environment` — оточення (`production`, `development`, `testing`)
-   `debug` — режим відлагодження (`true`/`false`)
-   `timezone` — часовий пояс
-   `locale` — локаль

### cache.ini

Налаштування кешування:

```ini
[cache]
driver = "file"
ttl = 3600
prefix = "flowaxy_"
```

**Параметри:**

-   `driver` — драйвер кешу (`file`, `database`, `memory`)
-   `ttl` — час життя кешу (в секундах)
-   `prefix` — префікс для ключів кешу

### database.ini

Налаштування бази даних (створюється через адмін-панель):

```ini
[database]
host = "localhost"
port = "3306"
name = "flowaxy_db"
user = "root"
password = ""
charset = "utf8mb4"
collation = "utf8mb4_unicode_ci"
```

**Примітка:** Цей файл створюється автоматично при налаштуванні БД через адмін-панель.

### security.ini

Налаштування безпеки:

```ini
[security]
csrf_enabled = true
session_lifetime = 7200
password_min_length = 8
encryption_key = ""
```

**Параметри:**

-   `csrf_enabled` — увімкнення CSRF захисту
-   `session_lifetime` — час життя сесії (в секундах)
-   `password_min_length` — мінімальна довжина пароля
-   `encryption_key` — ключ шифрування (генерується автоматично)

### logging.ini

Налаштування логування:

```ini
[logging]
level = "error"
driver = "file"
path = "storage/logs"
```

**Параметри:**

-   `level` — рівень логування (`debug`, `info`, `warning`, `error`)
-   `driver` — драйвер логування (`file`, `database`)
-   `path` — шлях до файлів логів

### plugins.ini

Статуси плагінів (створюється автоматично):

```ini
[plugins]
social-networks = "activated"
slider-manager = "installed"
page-builder = "deactivated"
```

**Статуси:**

-   `non-install` — не встановлений
-   `installed` — встановлений
-   `activated` — активований
-   `deactivated` — деактивований

### themes.ini

Статуси тем (створюється автоматично):

```ini
[themes]
default = "activated"
theme-1 = "deactivated"
theme-2 = "installed"
```

**Статуси:**

-   `non-install` — не встановлена
-   `installed` — встановлена
-   `activated` — активована (тільки одна тема може бути активована)
-   `deactivated` — деактивована

## Конфігурації плагінів

Кожен плагін може мати власний файл конфігурації в `storage/config/plugins/{plugin-slug}.ini`:

```ini
[settings]
setting_key = "value"
another_setting = "value"
```

**Приклад** (плагін social-networks):

```ini
[settings]
status = "activated"
```

## Конфігурації тем

Кожна тема може мати власний файл конфігурації в `storage/config/themes/{theme-slug}.ini`:

```ini
[settings]
setting_key = "value"
```

## site.php

Глобальні налаштування сайту:

```php
<?php
return [
    'site_name' => 'Flowaxy CMS',
    'site_url' => 'https://example.com',
    'admin_email' => 'admin@example.com',
];
```

## Змінні оточення

Система підтримує змінні оточення через `.env` файл (якщо використовується):

```env
APP_ENV=production
APP_DEBUG=false
DB_HOST=localhost
DB_NAME=flowaxy_db
DB_USER=root
DB_PASS=
```

## Автоматичне створення конфігурацій

Система автоматично створює необхідні конфігураційні файли при першому запуску:

1. **Директорії** — `storage/config/system/`, `storage/config/plugins/`, `storage/config/themes/`
2. **Системні файли** — `app.ini`, `cache.ini`, `security.ini`, `logging.ini`
3. **Файли статусів** — `plugins.ini`, `themes.ini` (якщо є плагіни/темі)

## Редагування конфігурацій

### Через адмін-панель

Більшість налаштувань можна змінити через адмін-панель:

-   **Налаштування сайту** → `/admin/site-settings`
-   **База даних** → `/admin/database`
-   **Безпека** → `/admin/settings`
-   **Плагіни** → `/admin/plugins` (налаштування конкретного плагіна)
-   **Темі** → `/admin/themes` (налаштування конкретної теми)

### Вручну

Конфігураційні файли можна редагувати вручну, але **рекомендується** використовувати адмін-панель для безпеки та валідації.

## Формат файлів

### INI файли

Система використовує формат INI з секціями:

```ini
[section_name]
key = "value"
another_key = "value"
```

### JSON файли

Деякі конфігурації (наприклад, `services.json`) використовують формат JSON:

```json
{
    "bindings": {
        "interface": "implementation"
    },
    "singletons": ["ClassName"]
}
```

## Безпека конфігурацій

### Захист файлів

Система автоматично створює `.htaccess` файли для захисту конфігурацій:

```apache
# storage/config/.htaccess
<FilesMatch "\.(ini|json|php)$">
    Order allow,deny
    Deny from all
</FilesMatch>
```

### Чутливі дані

**НЕ зберігайте** чутливі дані (паролі, ключі) безпосередньо в конфігураційних файлах. Використовуйте:

-   Змінні оточення
-   Шифрування (для паролів БД)
-   Безпечне зберігання ключів

## Перезавантаження конфігурацій

Після зміни конфігураційних файлів:

1. **Очистіть кеш** через адмін-панель → `/admin/cache-clear`
2. Або видаліть файли в `storage/cache/` вручну

## Приклади конфігурацій

### Розробка (development)

```ini
[app]
environment = "development"
debug = true
```

### Продакшн (production)

```ini
[app]
environment = "production"
debug = false
```

### Тестування (testing)

```ini
[app]
environment = "testing"
debug = true
```

---

**Конфігурація налаштована!** Переходьте до [перших кроків](First-Steps).
