# Приклад: Проста тема

Повний приклад простої теми для FLOWAXY-CMS.

## Структура

```
content/themes/simple-theme/
├── Theme.php
├── templates/
│   └── default.php
└── resources/
    ├── styles/
    │   └── style.css
    └── scripts/
        └── main.js
```

## Theme.php

```php
<?php

/**
 * Simple Theme
 *
 * @name: Simple Theme
 * @slug: simple-theme
 * @version: 1.0.0
 * @description: Проста тема для FLOWAXY-CMS
 * @author: Your Name
 * @author_url: https://example.com
 * @requires: 1.0.0
 * @tested: 1.0.0
 * @package: SimpleTheme
 */

declare(strict_types=1);

use Flowaxy\Support\Base\BaseTheme;

final class Theme extends BaseTheme
{
    public function registerHooks(): void
    {
        // Підтримка віджетів
        if (function_exists('add_theme_support')) {
            add_theme_support('widgets');
        }
    }

    public function renderTheme(): void
    {
        $this->render('default');
    }
}
```

## templates/default.php

```php
<!DOCTYPE html>
<html lang="uk">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle ?? 'Сайт'; ?></title>
    <link rel="stylesheet" href="<?php echo theme_asset('styles/style.css'); ?>">
</head>
<body>
    <header>
        <h1><?php echo htmlspecialchars($siteName ?? 'Flowaxy', ENT_QUOTES, 'UTF-8'); ?></h1>
    </header>

    <main>
        <h2>Головна сторінка</h2>
        <p>Вітаємо на сайті!</p>
    </main>

    <footer>
        <p>&copy; <?php echo date('Y'); ?></p>
    </footer>

    <script src="<?php echo theme_asset('scripts/main.js'); ?>"></script>
</body>
</html>
```

## resources/styles/style.css

```css
body {
    font-family: Arial, sans-serif;
    margin: 0;
    padding: 0;
}

header {
    background: #333;
    color: #fff;
    padding: 20px;
}

main {
    padding: 20px;
}

footer {
    background: #f0f0f0;
    padding: 20px;
    text-align: center;
}
```

## resources/scripts/main.js

```javascript
document.addEventListener('DOMContentLoaded', function() {
    console.log('Simple Theme loaded');
});
```

## Встановлення

1. Створіть директорію `content/themes/simple-theme/`
2. Створіть всі файли з кодом вище
3. Перейдіть в адмін-панель → Темі
4. Знайдіть "Simple Theme" та встановіть
5. Натисніть "Активувати"

## Наступні кроки

- [Створення теми](../Development/Themes/Creating-Theme) — детальне керівництво
- [Компоненти](../Development/Themes/Components) — створення компонентів

---

**Тема готова до використання!** 🎨
