# Приклад: Hello World Plugin

Повний приклад простого плагіна "Hello World".

## Структура

```
content/plugins/hello-world/
├── Plugin.php
└── README.md
```

## Plugin.php

```php
<?php

/**
 * Hello World Plugin
 *
 * @name: Hello World
 * @slug: hello-world
 * @version: 1.0.0
 * @description: Простий приклад плагіна
 * @author: Your Name
 * @author_url: https://example.com
 * @requires: 1.0.0
 * @tested: 1.0.0
 * @package: HelloWorld
 */

declare(strict_types=1);

use Flowaxy\Support\Base\BasePlugin;

final class Plugin extends BasePlugin
{
    public function registerHooks(): void
    {
        // Реєстрація Action
        $this->registerAction('init', function() {
            echo 'Hello World Plugin initialized!';
        });

        // Реєстрація Filter
        $this->registerFilter('the_title', function($title) {
            return 'Hello World: ' . $title;
        });
    }

    public function registerRoutes(): void
    {
        // Без маршрутів для цього прикладу
    }

    public function install(): void
    {
        parent::install();
        // Ініціалізація при встановленні
    }

    public function activate(): void
    {
        parent::activate();
        // Активація плагіна
    }

    public function deactivate(): void
    {
        parent::deactivate();
        // Деактивація плагіна
    }

    public function uninstall(): void
    {
        parent::uninstall();
        // Видалення плагіна
    }
}
```

## README.md

```markdown
# Hello World Plugin

Простий приклад плагіна для FLOWAXY-CMS.

## Встановлення

1. Скопіюйте плагін в `content/plugins/hello-world/`
2. Перейдіть в адмін-панель → Плагіни
3. Знайдіть "Hello World" та натисніть "Встановити"
4. Натисніть "Активувати"

## Використання

Плагін автоматично виводить "Hello World Plugin initialized!" при ініціалізації системи та додає "Hello World: " до всіх заголовків.
```

## Встановлення

1. Створіть директорію `content/plugins/hello-world/`
2. Створіть файл `Plugin.php` з кодом вище
3. Створіть файл `README.md` з описом
4. Перейдіть в адмін-панель → Плагіни
5. Знайдіть "Hello World" та встановіть

## Наступні кроки

- [Створення плагіна](../Development/Plugins/Creating-Plugin) — детальне керівництво
- [Приклади плагінів](../Development/Plugins/Examples) — більше прикладів

---

**Плагін готовий до використання!** 👋
