# Приклади тем

Повні приклади тем для FLOWAXY-CMS з детальним описом.

## Default Theme

Повнофункціональна тема за замовчуванням з компонентами, віджетами та адаптивним дизайном.

### Опис

Default Theme — це базова тема для Flowaxy CMS, оптимізована та готова до використання як шаблон для подальшої розробки.

### Структура

```
content/themes/default/
├── Theme.php
├── components/
│   ├── auth/
│   ├── slider/
│   └── social-networks/
├── widgets/
│   ├── marketplace/
│   ├── portfolio/
│   ├── blogs/
│   └── testimonials/
├── layouts/
│   └── main.php
├── templates/
│   └── default.php
└── resources/
    ├── styles/
    ├── scripts/
    ├── fonts/
    └── library/
```

### Theme.php

```php
<?php

/**
 * Default Theme
 *
 * @name: Default
 * @slug: default
 * @version: 1.0.0
 * @description: Тема по умолчанию для Flowaxy CMS
 * @author: Flowaxy Team
 * @author_url: https://flowaxy.com
 * @requires: 1.0.0
 * @tested: 1.0.0
 * @package: DefaultTheme
 */

declare(strict_types=1);

use Flowaxy\Support\Base\BaseTheme;

final class DefaultTheme extends BaseTheme
{
    private array $menuLocations = [
        'header_left' => 'Header Left Menu',
        'header_center' => 'Header Center Menu',
        'footer' => 'Footer Menu',
    ];

    public function registerHooks(): void
    {
        // Підтримка можливостей
        if (function_exists('add_theme_support')) {
            add_theme_support('widgets');
            add_theme_support('menus', array_keys($this->menuLocations));
        }

        // Реєстрація областей меню
        if (function_exists('register_nav_menu')) {
            foreach ($this->menuLocations as $location => $name) {
                register_nav_menu($location, $name);
            }
        }
    }

    public function renderTheme(): void
    {
        $this->render('default');
    }
}
```

### Компоненти

#### Auth Component

Компонент авторизації та реєстрації.

**Використання:**
```php
<?php theme_component('auth'); ?>
```

#### Slider Component

Компонент слайдера зображень.

**Використання:**
```php
<?php theme_component('slider'); ?>
```

#### Social Networks Component

Компонент соціальних мереж (інтеграція з плагіном).

**Використання:**
```php
<?php theme_component('social-networks'); ?>
```

### Віджети

#### Marketplace Widget

Віджет магазину плагінів та тем.

**Використання:**
```php
<?php theme_widget('marketplace', ['items' => $items]); ?>
```

#### Portfolio Widget

Віджет портфоліо проектів.

**Використання:**
```php
<?php theme_widget('portfolio', ['items' => $items]); ?>
```

#### Blogs Widget

Віджет блогів.

**Використання:**
```php
<?php theme_widget('blogs', ['posts' => $posts]); ?>
```

#### Testimonials Widget

Віджет відгуків клієнтів.

**Використання:**
```php
<?php theme_widget('testimonials', ['videos' => $videos]); ?>
```

### Макет

#### Main Layout

Основний макет теми з header, footer та sidebars.

**Структура:**
- Header з меню та пошуком
- Мобільні модальні вікна
- Структура з сайдбарами
- Footer з меню та соціальними мережами

### Шаблон

#### Default Template

Шаблон головної сторінки.

**Структура:**
- Slider компонент
- Віджети (marketplace, portfolio, blogs, testimonials)

## Простий приклад теми

Мінімальна тема з базовою функціональністю.

### Theme.php

```php
<?php

/**
 * Simple Theme
 *
 * @name: Simple Theme
 * @slug: simple-theme
 * @version: 1.0.0
 * @description: Простий приклад теми
 * @author: Your Name
 * @requires: 1.0.0
 * @tested: 1.0.0
 * @package: SimpleTheme
 */

declare(strict_types=1);

use Flowaxy\Support\Base\BaseTheme;

final class Theme extends BaseTheme
{
    public function registerHooks(): void
    {
        add_theme_support('widgets');
        add_theme_support('menus', ['header', 'footer']);
    }

    public function renderTheme(): void
    {
        $this->render('default');
    }
}
```

### layouts/main.php

```php
<!DOCTYPE html>
<html lang="uk">
<head>
    <meta charset="UTF-8">
    <title><?php echo $pageTitle ?? 'Сайт'; ?></title>
    <link rel="stylesheet" href="<?php echo theme_asset('styles/style.css'); ?>">
</head>
<body>
    <header>
        <h1><?php echo htmlspecialchars($siteName ?? 'Flowaxy', ENT_QUOTES, 'UTF-8'); ?></h1>
    </header>

    <main>
        <?php echo Theme::yield('content'); ?>
    </main>

    <footer>
        <p>&copy; <?php echo date('Y'); ?></p>
    </footer>
</body>
</html>
```

### templates/default.php

```php
<?php
use Flowaxy\Support\Theme\Theme;

Theme::extend('main', [
    'content' => function() {
        ?>
        <h1>Головна сторінка</h1>
        <p>Вітаємо на сайті!</p>
        <?php
    }
]);
?>
```

## Наступні кроки

- [Створення теми](Creating-Theme) — покрокове створення
- [Структура теми](Theme-Structure) — детальний опис структури
- [Компоненти](Components) — створення компонентів
- [Віджети](Widgets) — створення віджетів
- [Макети та шаблони](Layouts-Templates) — робота з макетами

---

**Приклади тем допоможуть швидко розпочати розробку!** 📚
