# Компоненти адмінки

Детальний опис використання компонентів адмін-панелі.

## Огляд

Компоненти адмінки — це переіспользувані елементи інтерфейсу, які визначаються через масиви конфігурації.

## Доступні компоненти

### Button (Кнопка)

Кнопки для дій.

**Використання:**
```php
render_button([
    'text' => 'Зберегти',
    'type' => 'submit',
    'class' => 'btn-primary',
    'icon' => 'fas fa-save',
    'href' => admin_url('settings'),
]);
```

**Параметри:**
- `text` — текст кнопки
- `type` — тип кнопки (`button`, `submit`, `reset`)
- `class` — CSS класи
- `icon` — іконка Font Awesome
- `href` — URL для посилання
- `onclick` — JavaScript обробник

### Form (Форма)

Форми для введення даних.

**Використання:**
```php
render_form([
    'action' => admin_url('settings'),
    'method' => 'POST',
    'fields' => [
        [
            'type' => 'text',
            'name' => 'setting1',
            'label' => 'Налаштування 1',
            'value' => $settings['setting1'] ?? '',
            'required' => true,
        ],
        [
            'type' => 'textarea',
            'name' => 'setting2',
            'label' => 'Налаштування 2',
            'value' => $settings['setting2'] ?? '',
        ],
        [
            'type' => 'select',
            'name' => 'setting3',
            'label' => 'Налаштування 3',
            'options' => [
                'option1' => 'Опція 1',
                'option2' => 'Опція 2',
            ],
            'value' => $settings['setting3'] ?? 'option1',
        ],
    ],
]);
```

**Типи полів:**
- `text` — текстовий ввід
- `textarea` — багаторядковий текст
- `select` — випадаючий список
- `checkbox` — чекбокс
- `radio` — радіо кнопка
- `file` — завантаження файлу
- `hidden` — приховане поле

### Modal (Модальне вікно)

Модальні вікна для діалогів.

**Використання:**
```php
render_modal([
    'id' => 'my-modal',
    'title' => 'Підтвердження',
    'content' => 'Ви впевнені, що хочете виконати цю дію?',
    'buttons' => [
        [
            'text' => 'Так',
            'class' => 'btn-primary',
            'onclick' => 'confirmAction()',
        ],
        [
            'text' => 'Ні',
            'class' => 'btn-secondary',
            'data-dismiss' => 'modal',
        ],
    ],
]);
```

**Параметри:**
- `id` — унікальний ідентифікатор
- `title` — заголовок модального вікна
- `content` — контент модального вікна
- `buttons` — масив кнопок
- `size` — розмір (`sm`, `lg`, `xl`)

### Notification (Сповіщення)

Сповіщення для повідомлень користувачу.

**Використання:**
```php
render_notification([
    'type' => 'success',
    'message' => 'Дані збережено успішно',
    'dismissible' => true,
]);
```

**Типи:**
- `success` — успішна операція
- `error` — помилка
- `warning` — попередження
- `info` — інформація

**Flash повідомлення:**
```php
// Встановлення повідомлення
set_flash_message('Дані збережено', 'success');

// Повідомлення автоматично відображається в layout
```

### Table (Таблиця)

Таблиці для відображення даних.

**Використання:**
```php
render_table([
    'headers' => ['ID', 'Назва', 'Статус', 'Дії'],
    'rows' => [
        [
            1,
            'Елемент 1',
            '<span class="badge bg-success">Активний</span>',
            '<a href="...">Редагувати</a>',
        ],
        [
            2,
            'Елемент 2',
            '<span class="badge bg-danger">Неактивний</span>',
            '<a href="...">Редагувати</a>',
        ],
    ],
    'class' => 'table-striped',
]);
```

**Параметри:**
- `headers` — масив заголовків
- `rows` — масив рядків
- `class` — додаткові CSS класи
- `responsive` — адаптивна таблиця

### Layout Components

#### Breadcrumbs

Навігаційні хлібні крихти.

**Використання:**
```php
render_admin_layout([
    'pageBreadcrumbs' => [
        ['text' => 'Головна', 'href' => admin_url('dashboard')],
        ['text' => 'Розділ', 'href' => admin_url('section')],
        ['text' => 'Сторінка'],
    ],
]);
```

#### Card

Картки для контенту.

**Використання:**
```php
includeComponent('layout/card', [
    'title' => 'Заголовок картки',
    'content' => 'Контент картки',
    'footer' => 'Футер картки',
]);
```

#### Stats Card

Картки статистики.

**Використання:**
```php
includeComponent('layout/stats-card', [
    'title' => 'Користувачі',
    'value' => '1,234',
    'icon' => 'fas fa-users',
    'color' => 'primary',
]);
```

## Приклади використання

### Форма з валідацією

```php
ob_start();
?>
<form method="POST" action="<?php echo admin_url('settings'); ?>">
    <?php echo csrf_token_field(); ?>
    <input type="hidden" name="action" value="save">

    <div class="form-group">
        <label>Назва сайту</label>
        <input type="text" name="site_name"
               value="<?php echo htmlspecialchars($settings['site_name'] ?? '', ENT_QUOTES, 'UTF-8'); ?>"
               class="form-control" required>
    </div>

    <div class="form-group">
        <label>Email адміністратора</label>
        <input type="email" name="admin_email"
               value="<?php echo htmlspecialchars($settings['admin_email'] ?? '', ENT_QUOTES, 'UTF-8'); ?>"
               class="form-control" required>
    </div>

    <button type="submit" class="btn btn-primary">
        <i class="fas fa-save"></i> Зберегти
    </button>
</form>
<?php
$content = ob_get_clean();

render_admin_layout([
    'title' => 'Налаштування',
    'content' => $content,
]);
```

### Таблиця з діями

```php
$items = get_items();

ob_start();
?>
<div class="table-responsive">
    <table class="table table-striped">
        <thead>
            <tr>
                <th>ID</th>
                <th>Назва</th>
                <th>Статус</th>
                <th>Дії</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($items as $item): ?>
                <tr>
                    <td><?php echo htmlspecialchars($item['id'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                    <td><?php echo htmlspecialchars($item['name'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                    <td>
                        <?php if ($item['status'] ?? false): ?>
                            <span class="badge bg-success">Активний</span>
                        <?php else: ?>
                            <span class="badge bg-danger">Неактивний</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <a href="<?php echo admin_url('items/edit?id=' . $item['id']); ?>"
                           class="btn btn-sm btn-primary">
                            <i class="fas fa-edit"></i> Редагувати
                        </a>
                        <form method="POST" style="display: inline;"
                              onsubmit="return confirm('Ви впевнені?');">
                            <?php echo csrf_token_field(); ?>
                            <input type="hidden" name="action" value="delete">
                            <input type="hidden" name="id" value="<?php echo $item['id']; ?>">
                            <button type="submit" class="btn btn-sm btn-danger">
                                <i class="fas fa-trash"></i> Видалити
                            </button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
<?php
$content = ob_get_clean();

render_admin_layout([
    'title' => 'Елементи',
    'content' => $content,
]);
```

### Модальне вікно з формою

```php
ob_start();
?>
<!-- Кнопка для відкриття -->
<button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addModal">
    <i class="fas fa-plus"></i> Додати
</button>

<!-- Модальне вікно -->
<div class="modal fade" id="addModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="<?php echo admin_url('items'); ?>">
                <?php echo csrf_token_field(); ?>
                <input type="hidden" name="action" value="add">

                <div class="modal-header">
                    <h5 class="modal-title">Додати елемент</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label>Назва</label>
                        <input type="text" name="name" class="form-control" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Скасувати</button>
                    <button type="submit" class="btn btn-primary">Додати</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php
$content = ob_get_clean();

render_admin_layout([
    'title' => 'Елементи',
    'content' => $content,
]);
```

## Найкращі практики

### 1. Використовуйте компоненти

```php
// Добре: Використання компонентів
render_button(['text' => 'Зберегти', 'type' => 'submit']);

// Погано: Прямий HTML
echo '<button type="submit">Зберегти</button>';
```

### 2. Екранування виводу

```php
// Добре: htmlspecialchars
echo htmlspecialchars($value, ENT_QUOTES, 'UTF-8');

// Погано: Без екранування
echo $value;
```

### 3. CSRF захист

```php
// Завжди додавайте CSRF токен
<?php echo csrf_token_field(); ?>
```

## Наступні кроки

- [Створення сторінок](Creating-Pages) — покрокове створення сторінок
- [Кастомізація](Customization) — кастомізація адмін-панелі

---

**Компоненти забезпечують консистентність та переіспользуваність!** 🧩
