# Огляд архітектури FLOWAXY-CMS

Загальний огляд архітектури та принципів побудови FLOWAXY-CMS v.0.0.3 Pre.

## Архітектурні принципи

### 1. Чиста архітектура (Clean Architecture)

FLOWAXY-CMS побудована на принципах чистої архітектури з чітким розділенням на шари:

```
┌─────────────────────────────────────┐
│         Interface Layer             │  ← API, HTTP, CLI
├─────────────────────────────────────┤
│         Application Layer           │  ← Use Cases, Services
├─────────────────────────────────────┤
│         Domain Layer                │  ← Entities, Business Logic
├─────────────────────────────────────┤
│      Infrastructure Layer           │  ← DB, Cache, Filesystem
└─────────────────────────────────────┘
```

### 2. Строга ізоляція

Система розділена на дві повністю ізольовані частини:

-   **`flowaxy/`** — чисте ядро (тільки PHP класи з namespace)
-   **`content/`** — ізольований контент (тільки функції та масиви, БЕЗ класів)

### 3. Dependency Inversion

Всі залежності спрямовані від зовнішніх шарів до внутрішніх:

-   Interface залежить від Domain
-   Infrastructure залежить від Domain
-   Domain не залежить від нічого

## Структура проекту

```
flowaxy-cms/
├── flowaxy/              # ⚠️ ЧИСТЕ ЯДРО (тільки PHP класи)
│   ├── Bootstrap/        # Запуск та ініціалізація
│   ├── Contracts/       # Інтерфейси (контракти)
│   ├── Core/            # Внутрішні механізми ядра
│   ├── Domain/           # Бізнес-логіка (DDD)
│   ├── Infrastructure/   # Реалізації (DB, Cache, Mail...)
│   ├── Interface/        # API/HTTP/CLI інтерфейси
│   └── Support/          # Фасади, хелпери, менеджери
│
├── content/              # ⚠️ ІЗОЛЬОВАНИЙ КОНТЕНТ
│   ├── admin/            # Адмін-панель
│   ├── plugins/          # Плагіни
│   └── themes/            # Темі
│
└── storage/              # Дані системи
    ├── config/           # Конфігурації
    ├── cache/            # Кеш
    ├── logs/             # Логи
    └── sessions/         # Сесії
```

## Шари архітектури

### Domain Layer (Бізнес-логіка)

**Розташування:** `flowaxy/Domain/`

**Призначення:** Містить бізнес-логіку системи, незалежну від технічних деталей.

**Компоненти:**

-   **Entities** — бізнес-сутності (Plugin, Theme, User)
-   **Services** — бізнес-сервіси
-   **DTOs** — об'єкти передачі даних
-   **ValueObjects** — об'єкти-значення
-   **Queries** — запити до даних

**Принципи:**

-   Не залежить від Infrastructure
-   Не залежить від Interface
-   Містить тільки бізнес-логіку

### Infrastructure Layer (Реалізації)

**Розташування:** `flowaxy/Infrastructure/`

**Призначення:** Реалізація технічних деталей (БД, кеш, файли, безпека).

**Компоненти:**

-   **Database** — робота з БД
-   **Cache** — система кешування
-   **Filesystem** — робота з файлами
-   **Security** — безпека (CSRF, Encryption, Hash)
-   **Logging** — логування
-   **Mail** — відправка пошти
-   **Config** — конфігурації

**Принципи:**

-   Реалізує інтерфейси з Contracts
-   Залежить від Domain
-   Ізольована від Interface

### Interface Layer (Інтерфейси)

**Розташування:** `flowaxy/Interface/`

**Призначення:** Точки входу в систему (HTTP, CLI, API).

**Компоненти:**

-   **Http** — HTTP контроллери, Request, Response
-   **API** — REST API endpoints
-   **CLI** — консольні команди
-   **UI** — UI компоненти

**Принципи:**

-   Залежить від Domain
-   Використовує Infrastructure через інтерфейси
-   Не містить бізнес-логіки

### Core Layer (Внутрішні механізми)

**Розташування:** `flowaxy/Core/`

**Призначення:** Внутрішні механізми ядра (DI, Hooks, Routing, Events).

**Компоненти:**

-   **System/Container** — DI контейнер
-   **Hooks** — система хуків (Actions, Filters)
-   **Routing** — маршрутизація
-   **Events** — система подій
-   **System/Kernel** — ядро системи

## Ключові компоненти

### Dependency Injection Container

DI контейнер для управління залежностями та життєвим циклом об'єктів.

**Особливості:**

-   Автоматична інжекція залежностей
-   Singleton та Transient об'єкти
-   Lazy loading
-   Service Providers

**Детальніше:** [Dependency Injection](Dependency-Injection)

### Система хуків

Система Actions та Filters для розширення функціональності.

**Типи хуків:**

-   **Actions** — виконання дій (без повернення значення)
-   **Filters** — фільтрація даних (з поверненням значення)

**Детальніше:** [Система хуків](Hooks-System)

### Маршрутизація

Гнучка система маршрутизації з підтримкою параметрів та middleware.

**Особливості:**

-   Параметри маршрутів (`{id}`, `{slug}`)
-   Middleware для обробки запитів
-   Групування маршрутів
-   Автоматична завантаження маршрутів

**Детальніше:** [Маршрутизація](Routing)

## Ізоляція контенту

### Принцип ізоляції

`content/` повністю ізольований від ядра:

-   **Немає класів** — тільки функції та масиви
-   **Немає namespace** — глобальний простір імен
-   **Взаємодія через хуки** — Actions та Filters

### Структура content/

```
content/
├── admin/        # Адмін-панель (функції сторінок)
├── plugins/      # Плагіни (реєстрація через хуки)
└── themes/       # Темі (класи тем успадковують BaseTheme)
```

## Життєвий цикл запиту

```mermaid
graph TD
    A[HTTP Request] --> B[index.php]
    B --> C[Application::run]
    C --> D[Bootstrap Classes]
    D --> E[Container Initialization]
    E --> F[Service Providers]
    F --> G[Router]
    G --> H[Route Matching]
    H --> I[Middleware]
    I --> J[Controller/Handler]
    J --> K[Domain Services]
    K --> L[Infrastructure]
    L --> M[Response]
    M --> N[HTTP Response]
```

## Завантаження класів

### Автоматична завантаження

Всі класи з `flowaxy/` завантажуються автоматично:

1. **Рекурсивне сканування** — всі директорії `flowaxy/`
2. **Ліниве завантаження** — класи завантажуються при першому зверненні
3. **PSR-4 сумісність** — namespace відповідає структурі папок

### ClassAutoloader

```php
// Автоматично завантажує класи з flowaxy/
use Flowaxy\Core\System\Autoloader\ClassAutoloader;

// Клас автоматично завантажиться при першому використанні
$container = new \Flowaxy\Core\System\Container\Container();
```

## Розширення системи

### Плагіни

Плагіни розширюють функціональність через:

-   **Хуки** — Actions та Filters
-   **Маршрути** — власні URL
-   **Адмін-сторінки** — інтерфейс в адмінці
-   **Сервіси** — реєстрація в DI контейнері

**Детальніше:** [Розробка плагінів](../Development/Plugins/Overview)

### Темі

Темі надають інтерфейс користувача:

-   **Компоненти** — переіспользувані блоки
-   **Віджети** — блоки контенту
-   **Макети** — структура сторінок
-   **Шаблони** — конкретні сторінки

**Детальніше:** [Розробка тем](../Development/Themes/Overview)

## Безпека

### Захист на рівні архітектури

-   **CSRF** — захист від міжсайтових запитів
-   **XSS** — захист від ін'єкцій скриптів
-   **SQL Injection** — підготовлені запити
-   **CSP** — Content Security Policy
-   **Ізоляція** — плагіни та темі ізольовані

**Детальніше:** [Безпека](../Guides/Security)

## Продуктивність

### Оптимізації

-   **Кешування** — багаторівневий кеш
-   **Ліниве завантаження** — класи завантажуються при потребі
-   **Автозавантаження** — оптимізоване сканування
-   **DI контейнер** — singleton об'єкти

**Детальніше:** [Продуктивність](../Guides/Performance)

## Наступні кроки

-   [Структура ядра](Core-Structure) — детальний опис `flowaxy/`
-   [Структура контенту](Content-Structure) — детальний опис `content/`
-   [Система хуків](Hooks-System) — Actions та Filters
-   [Маршрутизація](Routing) — роутинг та маршрути
-   [Dependency Injection](Dependency-Injection) — DI контейнер

---

**Архітектура FLOWAXY-CMS забезпечує гнучкість, безпеку та продуктивність!** 🏗️
