# Структура ядра (flowaxy/)

Детальний опис структури ядра системи FLOWAXY-CMS.

## Загальний огляд

Ядро системи знаходиться в папці `flowaxy/` і містить **тільки PHP класи** з namespace. Всі класи оптимізовані для PHP 8.4+ з використанням суворої типізації.

## Структура flowaxy/

```
flowaxy/
├── Bootstrap/          # 🚀 Запуск та ініціалізація ядра (16 файлів)
├── Contracts/          # 📋 Інтерфейси функціональних компонентів (30+ файлів)
├── Core/               # ⚙️ Внутрішні механізми ядра (50+ файлів)
├── Domain/             # 💼 Бізнес-логіка DDD (60+ файлів)
├── Infrastructure/     # 🔧 Реалізації (70+ файлів)
├── Interface/          # 🌐 API/HTTP/CLI інтерфейси (40+ файлів)
└── Support/            # 🛠️ Фасади, хелпери, менеджери (150+ файлів)
```

## Bootstrap/ — Запуск ядра

**Призначення:** Ініціалізація системи, завантаження компонентів, перевірка оточення.

### Основні класи

#### Application.php

Головний клас додатку, точка входу для всіх запитів.

**Функції:**

-   Ініціалізація всіх компонентів системи
-   Запуск Kernel
-   Обробка HTTP та CLI запитів

**Приклад:**

```php
// index.php
$app = new Application();
$app->run();
```

#### AutoloaderInitializer.php

Ініціалізація автозавантажувача класів.

**Функції:**

-   Рекурсивне сканування `flowaxy/`
-   Реєстрація директорій в `ClassAutoloader`
-   Ліниве завантаження класів

#### ContainerInitializer.php

Ініціалізація DI контейнера.

**Функції:**

-   Створення та налаштування контейнера
-   Реєстрація базових сервісів
-   Налаштування Service Providers

#### ServiceProviderLoader.php

Завантаження сервіс-провайдерів.

**Функції:**

-   Завантаження всіх сервіс-провайдерів
-   Реєстрація сервісів в контейнері
-   Ініціалізація сервісів

#### RouterLoader.php

Завантаження маршрутів.

**Функції:**

-   Завантаження маршрутів з `content/admin/includes/admin-routes.php`
-   Реєстрація маршрутів плагінів
-   Налаштування базового шляху

## Contracts/ — Інтерфейси

**Призначення:** Визначення контрактів (інтерфейсів) для всіх функціональних компонентів системи.

### Основні інтерфейси

#### Assets/AssetManagerInterface.php

Інтерфейс для управління ресурсами (CSS, JS, зображення).

#### Cache/

-   **CacheInterface.php** — основний інтерфейс кешу
-   **CacheDriverInterface.php** — інтерфейс драйверів кешу
-   **CacheWarmerInterface.php** — інтерфейс для прогріву кешу

#### Database/

-   **DatabaseInterface.php** — інтерфейс роботи з БД
-   **QueryBuilderInterface.php** — інтерфейс побудови запитів

#### Domain/

Інтерфейси доменних сервісів:

-   **Content/ContentRepositoryInterface.php**
-   **Plugin/** (4 файли) — інтерфейси для плагінів
-   **Theme/** (2 файли) — інтерфейси для тем
-   **User/** (4 файли) — інтерфейси для користувачів

#### Security/

-   **EncryptionInterface.php** — шифрування
-   **HashInterface.php** — хешування
-   **SessionInterface.php** — робота з сесіями
-   **RateLimiterInterface.php** — обмеження частоти запитів

## Core/ — Внутрішні механізми ядра

**Призначення:** Зв'язувальні механізми ядра — DI контейнер, Kernel, Hooks, Routing, Events.

### Core/System/Container/

DI контейнер для управління залежностями.

**Основні класи:**

-   **Container.php** — основний контейнер
-   **CoreServiceProvider.php** — базовий сервіс-провайдер
-   **Providers/AuthServiceProvider.php** — провайдер аутентифікації
-   **Providers/ThemeServiceProvider.php** — провайдер тем

**Приклад використання:**

```php
// Реєстрація сервісу
$container->bind(LoggerInterface::class, Logger::class);

// Отримання сервісу
$logger = $container->make(LoggerInterface::class);
```

### Core/Hooks/

Система хуків для розширення функціональності.

**Основні класи:**

-   **HookManager.php** — менеджер хуків
-   **Action.php** — клас для Actions
-   **Filter.php** — клас для Filters
-   **HookRegistry.php** — реєстр хуків

**Детальніше:** [Система хуків](Hooks-System)

### Core/Routing/

Система маршрутизації HTTP запитів.

**Основні класи:**

-   **Router.php** — основний роутер
-   **RouterManager.php** — менеджер роутерів
-   **Route.php** — клас маршруту
-   **RouteMatcher.php** — зіставлення маршрутів

**Детальніше:** [Маршрутизація](Routing)

### Core/System/Kernel/

Ядро системи для обробки запитів.

**Основні класи:**

-   **Kernel.php** — базовий клас ядра
-   **HttpKernel.php** — HTTP ядро
-   **CliKernel.php** — CLI ядро

## Domain/ — Бізнес-логіка

**Призначення:** Доменна логіка додатку, слідування принципам Domain-Driven Design.

### Domain/Plugin/

Бізнес-логіка плагінів.

**Entities:**

-   **Plugin.php** — сутність плагіна

**Services:**

-   **InstallPluginService.php** — встановлення плагіна
-   **ActivatePluginService.php** — активація плагіна
-   **DeactivatePluginService.php** — деактивація плагіна
-   **UninstallPluginService.php** — видалення плагіна

**ValueObjects:**

-   **PluginSlug.php** — slug плагіна
-   **PluginVersion.php** — версія плагіна

### Domain/Theme/

Бізнес-логіка тем.

**Entities:**

-   **Theme.php** — сутність теми

**Services:**

-   **ThemeService.php** — сервіс тем
-   **UpdateThemeSettingsService.php** — оновлення налаштувань теми

### Domain/User/

Бізнес-логіка користувачів.

**Entities:**

-   **User.php** — користувач
-   **Role.php** — роль
-   **AdminUser.php** — адміністратор
-   **AdminRole.php** — роль адміністратора

**Services:**

-   **AuthenticateUserService.php** — аутентифікація
-   **RegisterUserService.php** — реєстрація
-   **AuthorizationService.php** — авторизація

## Infrastructure/ — Реалізації

**Призначення:** Реалізація інтерфейсів з `Contracts/`, робота з зовнішніми системами.

### Infrastructure/Cache/

Система кешування.

**Основні класи:**

-   **Cache.php** — основний клас кешу
-   **MultiLevelCache.php** — багаторівневий кеш
-   **Drivers/FileCache.php** — файловий кеш
-   **Drivers/DatabaseCache.php** — кеш в БД
-   **Drivers/MemoryCache.php** — кеш в пам'яті

### Infrastructure/Database/

Робота з базою даних.

**Основні класи:**

-   **Database.php** — основний клас БД
-   **QueryBuilder.php** — побудова запитів

**Приклад:**

```php
use Flowaxy\Support\Facades\Database;

$users = Database::table('users')
    ->where('status', 'active')
    ->get();
```

### Infrastructure/Security/

Безпека системи.

**Основні класи:**

-   **Encryption.php** — шифрування
-   **Hash.php** — хешування
-   **Session.php** — робота з сесіями
-   **CspHeaders.php** — Content Security Policy
-   **RateLimiter.php** — обмеження частоти запитів

### Infrastructure/Config/

Конфігурація системи.

**Основні класи:**

-   **Config.php** — основний клас конфігурації
-   **SystemConfig.php** — системна конфігурація
-   **PluginSettingsManager.php** — налаштування плагінів
-   **ThemeSettingsManager.php** — налаштування тем

## Interface/ — Інтерфейси

**Призначення:** Точки входу в систему (HTTP, CLI, API).

### Interface/Http/

HTTP інтерфейси.

**Основні класи:**

-   **Request.php** — HTTP запит
-   **Response.php** — HTTP відповідь
-   **Controller.php** — базовий контроллер
-   **Middleware.php** — базовий middleware

### Interface/API/

REST API endpoints.

**Основні класи:**

-   **ApiController.php** — базовий API контроллер
-   **RestApiController.php** — REST API контроллер

### Interface/CLI/

Консольні команди.

**Основні класи:**

-   **Command.php** — базовий клас команди
-   **CommandRunner.php** — виконавець команд

## Support/ — Фасади та хелпери

**Призначення:** Фасади, хелпери, менеджери для спрощення роботи з системою.

### Support/Facades/

36 фасадів системи для зручного доступу до функціоналу.

**Основні фасади:**

-   **App** — доступ до контейнера
-   **Cache** — кешування
-   **Database** — база даних
-   **Log** — логування
-   **Router** — маршрутизація
-   **Hooks** — система хуків
-   **Theme** — робота з темами
-   **Plugin** — робота з плагінами

**Приклад:**

```php
use Flowaxy\Support\Facades\Cache;
use Flowaxy\Support\Facades\Log;

Cache::put('key', 'value', 3600);
Log::info('Message');
```

### Support/Helpers/

44+ хелперів для спрощення роботи.

**Основні хелпери:**

-   **DatabaseHelper.php** — робота з БД
-   **CacheHelper.php** — робота з кешем
-   **SecurityHelper.php** — безпека
-   **ThemeHelper.php** — робота з темами
-   **PathHelper.php** — робота з шляхами

**Приклад:**

```php
// Глобальні функції
theme_component('slider');
theme_asset('css/style.css');
```

### Support/Managers/

Менеджери для управління компонентами.

**Основні менеджери:**

-   **PluginManager.php** — менеджер плагінів
-   **ThemeManager.php** — менеджер тем
-   **UserManager.php** — менеджер користувачів

## Принципи роботи

### Автоматична завантаження

Всі класи з `flowaxy/` завантажуються автоматично:

1. Рекурсивне сканування всіх директорій
2. Ліниве завантаження при першому зверненні
3. PSR-4 сумісність (namespace = структура папок)

### Dependency Injection

Всі залежності інжектуються через DI контейнер:

-   Автоматична інжекція через конструктор
-   Реєстрація через Service Providers
-   Singleton та Transient об'єкти

### Типобезпека

Всі класи використовують:

-   `declare(strict_types=1)` — сувора типізація
-   Type hints для параметрів та повернення
-   PHP 8.4+ можливості

## Наступні кроки

-   [Структура контенту](Content-Structure) — детальний опис `content/`
-   [Система хуків](Hooks-System) — Actions та Filters
-   [Маршрутизація](Routing) — роутинг та маршрути
-   [Dependency Injection](Dependency-Injection) — DI контейнер

---

**Ядро системи забезпечує надійну основу для розробки!** ⚙️
