# Theme API

Детальний опис API для роботи з темами.

## Огляд

Theme API надає методи для роботи з темами: рендеринг, assets, компоненти, віджети, макети та шаблони.

## Клас Theme

```php
use Flowaxy\Support\Theme\Theme;

// Рендеринг шаблону
Theme::render('default', $data, $return = false);

// Рендеринг макету
Theme::layout('main', $data, $return = false);

// Розширення макету
Theme::extend('main', [
    'content' => function() {
        // Контент
    }
]);

// Вставка секції
Theme::yield('content');

// Рендеринг компонента
Theme::component('slider', $props, $return = false);

// Отримання asset
$url = Theme::asset('css/style.css', $versioning = true);
```

## Фасад Theme

```php
use Flowaxy\Support\Facades\Theme;

// Отримання активної теми
$theme = Theme::active();

// Рендеринг компонента
Theme::component('slider');

// Отримання asset
$url = Theme::asset('css/style.css');
```

## Глобальні функції

### theme_component()

Рендеринг компонента теми.

```php
// Базове використання
theme_component('slider');

// З параметрами
theme_component('slider', [
    'slides' => $slides,
    'autoplay' => true,
]);

// З поверненням результату
$html = theme_component('slider', [], true);
```

### theme_asset()

Отримання URL asset теми.

```php
// З версіонуванням (за замовчуванням)
$url = theme_asset('css/style.css');

// Без версіонування
$url = theme_asset('css/style.css', false);
```

### theme_widget()

Рендеринг віджета теми.

```php
// Базове використання
theme_widget('marketplace');

// З параметрами
theme_widget('marketplace', [
    'title' => 'Магазин',
    'items' => $items,
]);
```

## ThemeComponentLoader

Завантаження компонентів теми.

```php
use Flowaxy\Support\Theme\ThemeComponentLoader;

// Завантаження компонента
$component = ThemeComponentLoader::component('slider', $props);

// Отримання URL asset компонента
$url = ThemeComponentLoader::getComponentAssetUrl('slider', 'component.css');
```

## Приклади використання

### Рендеринг шаблону

```php
use Flowaxy\Support\Theme\Theme;

Theme::render('default', [
    'title' => 'Головна сторінка',
    'content' => 'Контент',
]);
```

### Розширення макету

```php
use Flowaxy\Support\Theme\Theme;

Theme::extend('main', [
    'content' => function() {
        ?>
        <h1>Головна сторінка</h1>
        <?php
    },
    'sidebar' => function() {
        ?>
        <div>Бічна панель</div>
        <?php
    },
]);
```

### Використання компонентів

```php
// У шаблоні
<?php theme_component('slider'); ?>
<?php theme_component('auth'); ?>
<?php theme_component('social-networks'); ?>
```

### Використання віджетів

```php
// У шаблоні
<?php theme_widget('marketplace', ['items' => $items]); ?>
<?php theme_widget('portfolio', ['items' => $portfolioItems]); ?>
```

### Підключення assets

```php
// У макеті
<link rel="stylesheet" href="<?php echo theme_asset('styles/style.css'); ?>">
<script src="<?php echo theme_asset('scripts/main.js'); ?>"></script>
```

## Наступні кроки

- [Фасади](Facades) — всі фасади системи
- [Hooks API](Hooks-API) — API для роботи з хуками
- [Plugin API](Plugin-API) — API для роботи з плагінами

---

**Theme API забезпечує повний контроль над темами!** 🎨
