<?php

/**
 * Flowaxy CMS - Entry Point
 * Точка входу для всіх запитів
 *
 * @version 1.0.0
 */

declare(strict_types=1);

use \Flowaxy\Bootstrap\Application;

// Сокращение для DIRECTORY_SEPARATOR
define('DS', DIRECTORY_SEPARATOR);

// Глобальная переменная для часового пояса
$GLOBALS['_DEFAULT_TIMEZONE'] = 'Europe/Kyiv';

// Функция для получения часового пояса
if (!function_exists('getDefaultTimezone')) {
    function getDefaultTimezone(): string
    {
        return $GLOBALS['_DEFAULT_TIMEZONE'] ?? 'Europe/Kyiv';
    }
}

// Функция для генерации class map
// Все классы из flowaxy/ загружаются автоматически через рекурсивное сканирование директорий
// Ленивая загрузка - классы загружаются только при первом обращении
if (!function_exists('buildClassMap')) {
    function buildClassMap(): array
    {
        return [];
    }
}

// Завантажуємо Application клас для ініціалізації та запуску системи
require_once __DIR__ . DS . 'flowaxy' . DS . 'Bootstrap' . DS . 'Application.php';

// Запуск додатку
$app = new Application();
$app->run();
