<?php

/**
 * Правило валидации: обязательное поле
 *
 * @package Flowaxy\Support\Validation\Rules
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Support\Validation\Rules;

use Flowaxy\Contracts\Validation\RuleInterface;

class RequiredRule implements RuleInterface
{
    public function validate($value, array $params = []): bool
    {
        if (is_string($value)) {
            return trim($value) !== '';
        }

        if (is_array($value)) {
            return !empty($value);
        }

        return $value !== null;
    }

    public function getMessage(string $field, array $params = []): string
    {
        return "Поле {$field} является обязательным";
    }

    public function getName(): string
    {
        return 'required';
    }
}
