<?php

/**
 * Правило валидации: email
 *
 * @package Flowaxy\Support\Validation\Rules
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Support\Validation\Rules;

use Flowaxy\Contracts\Validation\RuleInterface;

class EmailRule implements RuleInterface
{
    public function validate($value, array $params = []): bool
    {
        if (empty($value)) {
            return true; // Пустое значение проверяется правилом Required
        }

        if (!is_string($value)) {
            return false;
        }

        return filter_var($value, FILTER_VALIDATE_EMAIL) !== false;
    }

    public function getMessage(string $field, array $params = []): string
    {
        return "Поле {$field} должно содержать корректный email адрес";
    }

    public function getName(): string
    {
        return 'email';
    }
}
