<?php

/**
 * Трейт для валидации данных
 * Предоставляет методы для валидации в классах
 *
 * @package Flowaxy\Support\Traits
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Support\Traits;

use Flowaxy\Support\Services\ValidationService;

trait ValidationTrait
{
    /**
     * Получение экземпляра ValidationService
     *
     * @return ValidationService
     */
    protected function getValidationService(): ValidationService
    {
        static $service = null;
        if ($service === null) {
            $service = new ValidationService();
        }
        return $service;
    }

    /**
     * Валидация slug
     *
     * @param string $slug Slug для валидации
     * @return array{valid: bool, error?: string}
     */
    protected function validateSlug(string $slug): array
    {
        return $this->getValidationService()->validateSlug($slug);
    }

    /**
     * Валидация email
     *
     * @param string $email Email для валидации
     * @return array{valid: bool, error?: string}
     */
    protected function validateEmail(string $email): array
    {
        return $this->getValidationService()->validateEmail($email);
    }

    /**
     * Валидация строки
     *
     * @param string $value Значение
     * @param array<string, mixed> $options Опции валидации
     * @return array{valid: bool, error?: string}
     */
    protected function validateString(string $value, array $options = []): array
    {
        return $this->getValidationService()->validateString($value, $options);
    }

    /**
     * Валидация файла
     *
     * @param array<string, mixed> $file Файл из $_FILES
     * @param array<string, mixed> $options Опции валидации
     * @return array{valid: bool, error?: string}
     */
    protected function validateFile(array $file, array $options = []): array
    {
        return $this->getValidationService()->validateFile($file, $options);
    }

    /**
     * Валидация темы
     *
     * @param string $themeSlug Slug темы
     * @return array{valid: bool, error?: string}
     */
    protected function validateTheme(string $themeSlug): array
    {
        return $this->getValidationService()->validateTheme($themeSlug);
    }

    /**
     * Валидация плагина
     *
     * @param string $pluginSlug Slug плагина
     * @return array{valid: bool, error?: string}
     */
    protected function validatePlugin(string $pluginSlug): array
    {
        return $this->getValidationService()->validatePlugin($pluginSlug);
    }
}
