<?php

/**
 * Трейт для роботи з сесією
 * Надає методи для роботи з сесією в класах
 *
 * @package Flowaxy\Support\Traits
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Support\Traits;

use Flowaxy\Support\Helpers\SessionHelper;
use Flowaxy\Support\Managers\SessionManager;

trait SessionTrait
{
    /**
     * Отримання менеджера сесії
     *
     * @return SessionManager|null
     */
    protected function getSessionManager(): ?SessionManager
    {
        return SessionHelper::getManager();
    }

    /**
     * Отримання ID користувача з сесії
     *
     * @return int
     */
    protected function getUserId(): int
    {
        return SessionHelper::getUserId();
    }

    /**
     * Перевірка, чи користувач аутентифікований
     *
     * @return bool
     */
    protected function isAuthenticated(): bool
    {
        return SessionHelper::isAuthenticated();
    }

    /**
     * Отримання flash повідомлення
     *
     * @param string $key
     * @param mixed $default
     * @return mixed
     */
    protected function getFlash(string $key, $default = null)
    {
        return SessionHelper::getFlash($key, $default);
    }

    /**
     * Встановлення flash повідомлення
     *
     * @param string $key
     * @param mixed $value
     * @return void
     */
    protected function setFlash(string $key, $value): void
    {
        SessionHelper::setFlash($key, $value);
    }

    /**
     * Отримання значення з сесії
     *
     * @param string $key
     * @param mixed $default
     * @return mixed
     */
    protected function getSession(string $key, $default = null)
    {
        return SessionHelper::get($key, $default);
    }

    /**
     * Встановлення значення в сесію
     *
     * @param string $key
     * @param mixed $value
     * @return void
     */
    protected function setSession(string $key, $value): void
    {
        SessionHelper::set($key, $value);
    }

    /**
     * Видалення значення з сесії
     *
     * @param string $key
     * @return void
     */
    protected function deleteSession(string $key): void
    {
        SessionHelper::delete($key);
    }
}
