<?php

/**
 * Трейт для санитизации данных
 * Предоставляет методы для санитизации в классах
 *
 * @package Flowaxy\Support\Traits
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Support\Traits;

use Flowaxy\Support\Helpers\SanitizationHelper;

trait SanitizationTrait
{
    /**
     * Санитизация slug
     *
     * @param string $slug Slug для санитизации
     * @return string
     */
    protected function sanitizeSlug(string $slug): string
    {
        return SanitizationHelper::sanitizeSlug($slug);
    }

    /**
     * Санитизация строки
     *
     * @param string $string Строка для санитизации
     * @param bool $stripTags Удалять HTML теги
     * @return string
     */
    protected function sanitizeString(string $string, bool $stripTags = true): string
    {
        return SanitizationHelper::sanitizeString($string, $stripTags);
    }

    /**
     * Санитизация массива
     *
     * @param array<string, mixed> $array Массив для санитизации
     * @return array<string, mixed>
     */
    protected function sanitizeArray(array $array): array
    {
        return SanitizationHelper::sanitizeArray($array);
    }

    /**
     * Санитизация email
     *
     * @param string $email Email для санитизации
     * @return string
     */
    protected function sanitizeEmail(string $email): string
    {
        return SanitizationHelper::sanitizeEmail($email);
    }

    /**
     * Санитизация URL
     *
     * @param string $url URL для санитизации
     * @return string
     */
    protected function sanitizeUrl(string $url): string
    {
        return SanitizationHelper::sanitizeUrl($url);
    }

    /**
     * Санитизация целого числа
     *
     * @param mixed $value Значение для санитизации
     * @param int|null $min Минимальное значение
     * @param int|null $max Максимальное значение
     * @return int
     */
    protected function sanitizeInt($value, ?int $min = null, ?int $max = null): int
    {
        return SanitizationHelper::sanitizeInt($value, $min, $max);
    }

    /**
     * Санитизация имени файла
     *
     * @param string $filename Имя файла
     * @return string
     */
    protected function sanitizeFilename(string $filename): string
    {
        return SanitizationHelper::sanitizeFilename($filename);
    }
}
