<?php

/**
 * Трейт для отримання менеджерів
 * Надає методи для отримання менеджерів системи
 *
 * @package Flowaxy\Support\Traits
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Support\Traits;

use Flowaxy\Support\Helpers\ManagerHelper;
use Flowaxy\Support\Managers\ThemeManager;
use Flowaxy\Support\Managers\PluginManager;
use Flowaxy\Support\Managers\RoleManager;
use Flowaxy\Infrastructure\Cache\Cache;
use Flowaxy\Interface\Http\Request;

trait ManagerTrait
{
    /**
     * Отримання менеджера тем
     *
     * @return ThemeManager|null
     */
    protected function themeManager(): ?ThemeManager
    {
        return ManagerHelper::themeManager();
    }

    /**
     * Отримання менеджера плагінів
     *
     * @return PluginManager|null
     */
    protected function pluginManager(): ?PluginManager
    {
        return ManagerHelper::pluginManager();
    }

    /**
     * Отримання менеджера ролей
     *
     * @return RoleManager|null
     */
    protected function roleManager(): ?RoleManager
    {
        return ManagerHelper::roleManager();
    }

    /**
     * Отримання менеджера кешу
     *
     * @return Cache|null
     */
    protected function cache(): ?Cache
    {
        return ManagerHelper::cache();
    }

    /**
     * Отримання об'єкта Request
     *
     * @return Request|null
     */
    protected function request(): ?Request
    {
        return ManagerHelper::request();
    }
}
