<?php

/**
 * Трейт для роботи з кешем
 * Надає методи для роботи з кешем
 *
 * @package Flowaxy\Support\Traits
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Support\Traits;

use Flowaxy\Support\Helpers\CacheHelper;

trait CacheTrait
{
    /**
     * Отримання значення з кешу
     *
     * @param string $key
     * @param mixed $default
     * @return mixed
     */
    protected function cacheGet(string $key, $default = null)
    {
        return CacheHelper::get($key, $default);
    }

    /**
     * Встановлення значення в кеш
     *
     * @param string $key
     * @param mixed $value
     * @param int|null $ttl
     * @return bool
     */
    protected function cacheSet(string $key, $value, ?int $ttl = null): bool
    {
        return CacheHelper::set($key, $value, $ttl);
    }

    /**
     * Видалення значення з кешу
     *
     * @param string $key
     * @return bool
     */
    protected function cacheForget(string $key): bool
    {
        return CacheHelper::forget($key);
    }

    /**
     * Отримання або встановлення значення з callback
     *
     * @param string $key
     * @param callable $callback
     * @param int|null $ttl
     * @return mixed
     */
    protected function cacheRemember(string $key, callable $callback, ?int $ttl = null)
    {
        return CacheHelper::remember($key, $callback, $ttl);
    }

    /**
     * Очищення кешу
     *
     * @param string|null $pattern
     * @return bool
     */
    protected function cacheClear(?string $pattern = null): bool
    {
        return CacheHelper::clear($pattern);
    }

    /**
     * Видалення кількох ключів одночасно
     *
     * @param array<string> $keys
     * @return int
     */
    protected function cacheForgetMultiple(array $keys): int
    {
        return CacheHelper::forgetMultiple($keys);
    }

    /**
     * Перевірка наявності ключа в кеші
     *
     * @param string $key
     * @return bool
     */
    protected function cacheHas(string $key): bool
    {
        return CacheHelper::has($key);
    }
}
