<?php

declare(strict_types=1);

/**
 * Bootstrap файл для тестов
 *
 * @package Tests
 */

// Определяем корневую директорию проекта
$projectRoot = dirname(__DIR__, 3);

// Базовые константы путей для тестов (аналогично runtime bootstrap)
if (!defined('DS')) {
    define('DS', DIRECTORY_SEPARATOR);
}
if (!defined('ROOT_DIR')) {
    define('ROOT_DIR', $projectRoot);
}
if (!defined('FLOWAXY_DIR')) {
    define('FLOWAXY_DIR', $projectRoot . DS . 'flowaxy');
}

// Загружаем PathResolver первым
require_once FLOWAXY_DIR . DS . 'Bootstrap' . DS . 'PathResolverInitializer.php';
\Flowaxy\Bootstrap\PathResolverInitializer::initialize();

// Загружаем AutoloaderInitializer
require_once FLOWAXY_DIR . DS . 'Bootstrap' . DS . 'AutoloaderInitializer.php';

// Инициализируем автозагрузчик (AutoloaderInitializer ожидает callable)
try {
    \Flowaxy\Bootstrap\AutoloaderInitializer::initialize(static fn(): array => []);
} catch (Throwable $e) {
    echo "Failed to initialize autoloader: " . $e->getMessage() . "\n";
    exit(1);
}
