<?php

declare(strict_types=1);

namespace Tests;

/**
 * Базовый класс для всех тестов Flowaxy
 *
 * @package Tests
 * @phpstan-ignore-next-line
 */
abstract class TestCase extends \PHPUnit\Framework\TestCase
{
    /**
     * Путь к корневой директории проекта
     */
    protected string $projectRoot;

    /**
     * Путь к директории flowaxy
     */
    protected string $flowaxyDir;

    /**
     * Путь к директории content
     */
    protected string $contentDir;

    /**
     * Установка перед каждым тестом
     */
    protected function setUp(): void
    {
        parent::setUp();

        // flowaxy/Support/Tests -> flowaxy/Support -> flowaxy -> project root
        $this->projectRoot = dirname(__DIR__, 3);
        $this->flowaxyDir = $this->projectRoot . DIRECTORY_SEPARATOR . 'flowaxy';
        $this->contentDir = $this->projectRoot . DIRECTORY_SEPARATOR . 'content';
    }

    /**
     * Очистка после каждого теста
     */
    protected function tearDown(): void
    {
        parent::tearDown();
    }

    /**
     * Получить путь к тестовым данным
     */
    protected function getTestDataPath(string $path = ''): string
    {
        $testDataDir = $this->projectRoot . DIRECTORY_SEPARATOR . 'flowaxy'
            . DIRECTORY_SEPARATOR . 'Support'
            . DIRECTORY_SEPARATOR . 'Tests'
            . DIRECTORY_SEPARATOR . 'data';
        return $path !== '' ? $testDataDir . DIRECTORY_SEPARATOR . $path : $testDataDir;
    }

    /**
     * Получить путь к временным файлам
     */
    protected function getTempPath(string $path = ''): string
    {
        $tempDir = $this->projectRoot . DIRECTORY_SEPARATOR . 'storage' . DIRECTORY_SEPARATOR . 'temp' . DIRECTORY_SEPARATOR . 'tests';
        if (!is_dir($tempDir)) {
            mkdir($tempDir, 0755, true);
        }
        return $path !== '' ? $tempDir . DIRECTORY_SEPARATOR . $path : $tempDir;
    }
}
