<?php

declare(strict_types=1);

namespace Tests\Support\Facades;

use Flowaxy\Support\Facades\Log;
use Tests\TestCase;

/**
 * Тесты для Log facade
 *
 * @package Tests\Support\Facades
 */
final class LogTest extends TestCase
{
    /**
     * Тест логирования ошибки
     */
    public function testError(): void
    {
        try {
            Log::Error('Test error message', ['context' => 'test']);
            $this->assertTrue(true);
        } catch (\Throwable $e) {
            $this->fail('Log::Error should not throw exception: ' . $e->getMessage());
        }
    }

    /**
     * Тест логирования предупреждения
     */
    public function testWarning(): void
    {
        try {
            Log::Warning('Test warning message', ['context' => 'test']);
            $this->assertTrue(true);
        } catch (\Throwable $e) {
            $this->fail('Log::Warning should not throw exception: ' . $e->getMessage());
        }
    }

    /**
     * Тест логирования информации
     */
    public function testInfo(): void
    {
        try {
            Log::Info('Test info message', ['context' => 'test']);
            $this->assertTrue(true);
        } catch (\Throwable $e) {
            $this->fail('Log::Info should not throw exception: ' . $e->getMessage());
        }
    }
}
