<?php

declare(strict_types=1);

namespace Tests\Security;

use PHPUnit\Framework\TestCase;

/**
 * Security тесты для защиты от XSS
 * Запускаются только nightly или вручную
 *
 * @package Tests\Security
 * @group security
 */
final class XssAttemptTest extends TestCase
{
    public function testHtmlSpecialChars(): void
    {
        $xssAttempt = '<script>alert("XSS")</script>';
        $escaped = htmlspecialchars($xssAttempt, ENT_QUOTES, 'UTF-8');

        $this->assertStringNotContainsString('<script>', $escaped);
        $this->assertStringNotContainsString('</script>', $escaped);
    }

    public function testHtmlEntities(): void
    {
        $xssAttempt = '<img src=x onerror=alert("XSS")>';
        $escaped = htmlentities($xssAttempt, ENT_QUOTES, 'UTF-8');

        $this->assertStringNotContainsString('onerror=', $escaped);
    }
}
