<?php

declare(strict_types=1);

namespace Tests\Security;

use Flowaxy\Infrastructure\Persistence\Database\QueryBuilder;
use PHPUnit\Framework\TestCase;

/**
 * Security тесты для защиты от SQL инъекций
 * Запускаются только nightly или вручную
 *
 * @package Tests\Security
 * @group security
 */
final class SqlInjectionTest extends TestCase
{
    public function testQueryBuilderPreventsSqlInjection(): void
    {
        $query = new QueryBuilder();
        $query->select('*')
            ->from('users')
            ->where('name', '=', "'; DROP TABLE users; --");

        $sql = $query->toSql();
        $bindings = $query->getBindings();

        // SQL должен использовать параметризованные запросы
        $this->assertStringContainsString('?', $sql);
        $this->assertNotEmpty($bindings);

        // Значение должно быть в bindings, а не в SQL
        $this->assertStringNotContainsString("DROP TABLE", $sql);
    }

    public function testWhereInPreventsSqlInjection(): void
    {
        $query = new QueryBuilder();
        $query->select('*')
            ->from('users')
            ->whereIn('id', ["1'; DROP TABLE users; --"]);

        $sql = $query->toSql();
        $bindings = $query->getBindings();

        // Должны использоваться параметризованные запросы
        $this->assertStringContainsString('?', $sql);
        $this->assertNotEmpty($bindings);
    }
}
