<?php

declare(strict_types=1);

namespace Tests\Security;

use PHPUnit\Framework\TestCase;

/**
 * Security тесты для CSRF валидации
 * Запускаются только nightly или вручную
 *
 * @package Tests\Security
 * @group security
 */
final class CsrfValidationTest extends TestCase
{
    public function testCsrfTokenGeneration(): void
    {
        // Проверяем, что токены генерируются
        $token1 = bin2hex(random_bytes(32));
        $token2 = bin2hex(random_bytes(32));

        $this->assertNotEquals($token1, $token2);
        $this->assertEquals(64, strlen($token1));
    }

    public function testCsrfTokenValidation(): void
    {
        $token = bin2hex(random_bytes(32));
        $storedToken = $token;

        $this->assertEquals($token, $storedToken);
    }
}
