# Flowaxy Framework — Тесты

## 📁 Структура тестов

```
tests/
├── Bootstrap/          # Тесты для Bootstrap компонентов
│   ├── AutoloaderInitializerTest.php
│   └── ProtocolDetectorTest.php
├── Core/               # Тесты для Core компонентов
│   └── System/
│       └── PathResolverTest.php
├── Domain/             # Тесты для Domain компонентов
│   ├── Plugin/
│   │   └── Services/
│   │       └── InstallPluginServiceTest.php
│   └── User/
│       └── Services/
│           └── AuthenticateUserServiceTest.php
├── Feature/            # Feature тесты (интеграционные)
│   └── TestCase.php
├── Infrastructure/     # Тесты для Infrastructure компонентов
│   └── Security/
│       └── HashTest.php
├── Interface/          # Тесты для Interface компонентов
│   └── CLI/           # Тесты для CLI команд
│       ├── CreateUserCommandTest.php
│       └── UpdatePasswordCommandTest.php
├── Support/           # Тесты для Support компонентов
│   └── Facades/
│       └── LogTest.php
├── Unit/              # Unit тесты
│   └── TestCase.php
├── TestCase.php       # Базовый класс для всех тестов
├── bootstrap.php      # Bootstrap файл для PHPUnit
└── README.md          # Документация по тестам
```

## 🚀 Запуск тестов

### Запуск всех тестов
```bash
vendor/bin/phpunit
```

### Запуск только Unit тестов
```bash
vendor/bin/phpunit --testsuite Unit
```

### Запуск только Feature тестов
```bash
vendor/bin/phpunit --testsuite Feature
```

### Запуск конкретного теста
```bash
vendor/bin/phpunit tests/Bootstrap/AutoloaderInitializerTest.php
```

## 📝 Правила написания тестов

### 1. Структура тестового класса

```php
<?php
declare(strict_types=1);

namespace Tests\Bootstrap;

use Flowaxy\Bootstrap\AutoloaderInitializer;
use Tests\TestCase;

final class AutoloaderInitializerTest extends TestCase
{
    public function testInitialize(): void
    {
        // Тест
    }
}
```

### 2. Использование базовых классов

- **`Tests\Unit\TestCase`** — для unit тестов
- **`Tests\Feature\TestCase`** — для feature тестов
- **`Tests\TestCase`** — базовый класс для всех тестов

### 3. Именование тестов

- Методы тестов должны начинаться с `test`
- Или использовать аннотацию `@test`
- Имена должны быть описательными

### 4. Следование документации

Все тесты должны следовать правилам из `docs/AI_GUIDE.md`:
- ✅ `declare(strict_types=1);` в начале каждого файла
- ✅ `final class` для всех тестовых классов
- ✅ Полная типизация всех параметров и возвращаемых значений
- ✅ Использование `use` statements для всех классов

## 🔧 Конфигурация

Конфигурация PHPUnit находится в `phpunit.xml`:
- Bootstrap файл: `tests/bootstrap.php`
- Кеш: `.phpunit.cache`
- Покрытие кода: включено для `flowaxy/`

## 📊 Покрытие кода

Для генерации отчета о покрытии:
```bash
vendor/bin/phpunit --coverage-html coverage
```

## 📋 Список тестов

### Bootstrap тесты
- `AutoloaderInitializerTest` — тесты инициализации автозагрузчика
- `ProtocolDetectorTest` — тесты определения протокола

### Core тесты
- `PathResolverTest` — тесты разрешения путей

### Domain тесты
- `AuthenticateUserServiceTest` — тесты сервиса аутентификации
- `InstallPluginServiceTest` — тесты сервиса установки плагинов

### Infrastructure тесты
- `HashTest` — тесты хеширования

### Interface тесты
- `CreateUserCommandTest` — тесты CLI команды создания пользователя
- `UpdatePasswordCommandTest` — тесты CLI команды обновления пароля

### Support тесты
- `LogTest` — тесты Log facade
