<?php

declare(strict_types=1);

namespace Tests\Performance;

use Flowaxy\Infrastructure\Persistence\Database\QueryBuilder;
use PHPUnit\Framework\TestCase;

/**
 * Performance тесты для QueryBuilder
 * Запускаются только nightly или вручную
 *
 * @package Tests\Performance
 * @group performance
 */
final class QueryBuilderPerformanceTest extends TestCase
{
    public function testQueryBuilderPerformance(): void
    {
        $start = microtime(true);

        for ($i = 0; $i < 1000; $i++) {
            $query = new QueryBuilder();
            $query->select('*')
                ->from('users')
                ->where('id', '=', $i)
                ->orderBy('name', 'ASC')
                ->limit(10);
            $query->toSql();
        }

        $duration = microtime(true) - $start;

        // QueryBuilder должен обрабатывать 1000 запросов быстрее чем за 1 секунду
        $this->assertLessThan(1.0, $duration, 'QueryBuilder должен быть быстрым');
    }
}
