<?php

declare(strict_types=1);

namespace Tests\Interface\CLI;

use Flowaxy\Interface\CLI\CommandInterface;
use Flowaxy\Interface\CLI\Commands\RootPasswordCommand;
use Tests\TestCase;

final class RootPasswordCommandTest extends TestCase
{
    public function testImplementsCommandInterface(): void
    {
        $command = new RootPasswordCommand();
        $this->assertInstanceOf(CommandInterface::class, $command);
    }

    public function testGetName(): void
    {
        $command = new RootPasswordCommand();
        $this->assertSame('root:password', $command->getName());
    }
}
