<?php

declare(strict_types=1);

namespace Tests\Interface\CLI;

use Flowaxy\Interface\CLI\CommandInterface;
use Flowaxy\Interface\CLI\Commands\ConfigGetCommand;
use Flowaxy\Interface\CLI\Commands\ConfigListCommand;
use Flowaxy\Interface\CLI\Commands\ConfigSetCommand;
use Flowaxy\Interface\CLI\Commands\ConfigShowCommand;
use Tests\TestCase;

final class ConfigCommandsTest extends TestCase
{
    public function testCommandsImplementInterface(): void
    {
        $this->assertInstanceOf(CommandInterface::class, new ConfigListCommand());
        $this->assertInstanceOf(CommandInterface::class, new ConfigShowCommand());
        $this->assertInstanceOf(CommandInterface::class, new ConfigGetCommand());
        $this->assertInstanceOf(CommandInterface::class, new ConfigSetCommand());
    }
}
