<?php

declare(strict_types=1);

namespace Tests\Integration;

use Flowaxy\Domain\User\Services\RegisterUserService;
use Flowaxy\Domain\User\ValueObjects\Email;
use Flowaxy\Domain\User\ValueObjects\Password;
use PHPUnit\Framework\TestCase;

/**
 * Интеграционные тесты для регистрации пользователей
 *
 * @package Tests\Integration
 */
final class UserRegistrationTest extends TestCase
{
    public function testRegisterUserServiceExists(): void
    {
        $this->assertTrue(class_exists(RegisterUserService::class));
    }

    public function testEmailValueObject(): void
    {
        $email = new Email('test@example.com');
        $this->assertEquals('test@example.com', $email->getValue());
    }

    public function testEmailValidation(): void
    {
        $this->expectException(\InvalidArgumentException::class);
        new Email('invalid-email');
    }

    public function testPasswordValueObject(): void
    {
        $password = new Password('secure_password_123');
        $this->assertTrue($password->verify('secure_password_123'));
    }

    public function testPasswordMinLength(): void
    {
        $this->expectException(\InvalidArgumentException::class);
        new Password('short');
    }
}
