<?php

declare(strict_types=1);

namespace Tests\Integration;

use Flowaxy\Domain\Plugin\Services\InstallPluginService;
use Flowaxy\Domain\Plugin\ValueObjects\PluginVersion;
use PHPUnit\Framework\TestCase;

/**
 * Интеграционные тесты для установки плагинов
 *
 * @package Tests\Integration
 */
final class PluginInstallationTest extends TestCase
{
    public function testInstallPluginServiceExists(): void
    {
        $this->assertTrue(class_exists(InstallPluginService::class));
    }

    public function testPluginVersionValueObject(): void
    {
        $version = new PluginVersion('1.0.0');
        $this->assertEquals('1.0.0', $version->getValue());
    }

    public function testPluginVersionValidation(): void
    {
        $this->expectException(\InvalidArgumentException::class);
        new PluginVersion('invalid-version');
    }

    public function testPluginVersionSemver(): void
    {
        $version1 = new PluginVersion('1.0.0');
        $version2 = new PluginVersion('1.0.1');

        $this->assertTrue($version2->isGreaterThan($version1));
    }
}
