<?php

declare(strict_types=1);

namespace Tests\Infrastructure\Security;

use Flowaxy\Contracts\Security\HashInterface;
use Flowaxy\Infrastructure\Security\Hash;
use Tests\TestCase;

/**
 * Тесты для Hash
 *
 * @package Tests\Infrastructure\Security
 */
final class HashTest extends TestCase
{
    private HashInterface $hash;

    protected function setUp(): void
    {
        parent::setUp();
        $this->hash = new Hash();
    }

    /**
     * Тест создания хеша
     */
    public function testMake(): void
    {
        $password = 'test_password_123';
        $hash = $this->hash->make($password);

        $this->assertIsString($hash);
        $this->assertNotEmpty($hash);
        $this->assertNotEquals($password, $hash);
    }

    /**
     * Тест проверки хеша
     */
    public function testCheck(): void
    {
        $password = 'test_password_123';
        $hash = $this->hash->make($password);

        $this->assertTrue($this->hash->check($password, $hash));
        $this->assertFalse($this->hash->check('wrong_password', $hash));
    }

    /**
     * Тест проверки необходимости перехеширования
     */
    public function testNeedsRehash(): void
    {
        $password = 'test_password_123';
        $hash = $this->hash->make($password);

        $this->assertFalse($this->hash->needsRehash($hash));
    }

    /**
     * Тест получения информации о хеше
     */
    public function testInfo(): void
    {
        $password = 'test_password_123';
        $hash = $this->hash->make($password);
        $info = $this->hash->info($hash);

        $this->assertIsArray($info);
        $this->assertArrayHasKey('algo', $info);
    }
}
