<?php

declare(strict_types=1);

namespace Tests\Infrastructure\Cache;

use Flowaxy\Infrastructure\Cache\Cache;
use PHPUnit\Framework\TestCase;

/**
 * Тесты для Cache
 *
 * @package Tests\Infrastructure\Cache
 */
final class CacheTest extends TestCase
{
    private Cache $cache;

    protected function setUp(): void
    {
        $this->cache = Cache::getInstance();
    }

    public function testSetAndGet(): void
    {
        $this->cache->set('test_key', 'test_value', 3600);
        $value = $this->cache->get('test_key');
        $this->assertEquals('test_value', $value);
    }

    public function testHas(): void
    {
        $this->cache->set('test_key', 'test_value', 3600);
        $this->assertTrue($this->cache->has('test_key'));
        $this->assertFalse($this->cache->has('non_existent'));
    }

    public function testDelete(): void
    {
        $this->cache->set('test_key', 'test_value', 3600);
        $this->cache->delete('test_key');
        $this->assertFalse($this->cache->has('test_key'));
    }

    public function testPull(): void
    {
        $this->cache->set('test_key', 'test_value', 3600);
        $value = $this->cache->pull('test_key');
        $this->assertEquals('test_value', $value);
        $this->assertFalse($this->cache->has('test_key'));
    }

    public function testIncrement(): void
    {
        $this->cache->set('counter', 0, 3600);
        $this->cache->increment('counter', 1);
        $this->assertEquals(1, $this->cache->get('counter'));
    }

    public function testDecrement(): void
    {
        $this->cache->set('counter', 5, 3600);
        $this->cache->decrement('counter', 1);
        $this->assertEquals(4, $this->cache->get('counter'));
    }
}
