<?php

declare(strict_types=1);

namespace Tests\Domain\User\Services;

use Flowaxy\Domain\User\Services\AuthenticateUserService;
use Tests\TestCase;

/**
 * Тесты для AuthenticateUserService
 *
 * @package Tests\Domain\User\Services
 */
final class AuthenticateUserServiceTest extends TestCase
{
    /**
     * Тест что сервис существует
     */
    public function testServiceExists(): void
    {
        $this->assertTrue(class_exists(AuthenticateUserService::class));
    }

    /**
     * Тест создания экземпляра сервиса
     */
    public function testCanInstantiate(): void
    {
        $service = new AuthenticateUserService();

        $this->assertInstanceOf(AuthenticateUserService::class, $service);
    }
}
