<?php

declare(strict_types=1);

namespace Tests\Domain\Plugin\Services;

use Flowaxy\Domain\Plugin\Services\InstallPluginService;
use Tests\TestCase;

/**
 * Тесты для InstallPluginService
 *
 * @package Tests\Domain\Plugin\Services
 */
final class InstallPluginServiceTest extends TestCase
{
    /**
     * Тест что сервис существует
     */
    public function testServiceExists(): void
    {
        $this->assertTrue(class_exists(InstallPluginService::class));
    }

    /**
     * Тест создания экземпляра сервиса
     */
    public function testCanInstantiate(): void
    {
        $service = new InstallPluginService();

        $this->assertInstanceOf(InstallPluginService::class, $service);
    }
}
