<?php

declare(strict_types=1);

namespace Tests\Core\System;

use Flowaxy\Core\System\PathResolver;
use Tests\TestCase;

/**
 * Тесты для PathResolver
 *
 * @package Tests\Core\System
 */
final class PathResolverTest extends TestCase
{
    /**
     * Тест получения корневой директории
     */
    public function testRoot(): void
    {
        $rootPath = PathResolver::root();

        $this->assertIsString($rootPath);
        $this->assertTrue(is_dir($rootPath));
    }

    /**
     * Тест получения пути к flowaxy
     */
    public function testFlowaxy(): void
    {
        $flowaxyPath = PathResolver::flowaxy();

        $this->assertIsString($flowaxyPath);
        $this->assertTrue(is_dir($flowaxyPath));
        $this->assertStringEndsWith('flowaxy', $flowaxyPath);
    }

    /**
     * Тест получения пути к content
     */
    public function testContent(): void
    {
        $contentPath = PathResolver::content();

        $this->assertIsString($contentPath);
        $this->assertTrue(is_dir($contentPath));
        $this->assertStringEndsWith('content', $contentPath);
    }

    /**
     * Тест получения пути к storage
     */
    public function testStorage(): void
    {
        $storagePath = PathResolver::storage();

        $this->assertIsString($storagePath);
        $this->assertStringEndsWith('storage', $storagePath);
    }

    /**
     * Тест получения пути к cache
     */
    public function testCache(): void
    {
        $cachePath = PathResolver::cache();

        $this->assertIsString($cachePath);
        $this->assertStringContainsString('cache', $cachePath);
    }
}
