<?php

declare(strict_types=1);

namespace Tests\Core\System\Container;

use Flowaxy\Core\System\Container\Container;
use PHPUnit\Framework\TestCase;

/**
 * Тесты для Container
 *
 * @package Tests\Core\System\Container
 */
final class ContainerTest extends TestCase
{
    private Container $container;

    protected function setUp(): void
    {
        $this->container = new Container();
    }

    public function testBindAndResolve(): void
    {
        $this->container->bind('test', fn() => 'value');
        $this->assertEquals('value', $this->container->make('test'));
    }

    public function testSingleton(): void
    {
        $this->container->singleton('singleton', fn() => new \stdClass());
        $instance1 = $this->container->make('singleton');
        $instance2 = $this->container->make('singleton');
        $this->assertSame($instance1, $instance2);
    }

    public function testHas(): void
    {
        $this->assertFalse($this->container->has('not_bound'));
        $this->container->bind('bound', fn() => 'value');
        $this->assertTrue($this->container->has('bound'));
    }

    public function testResolveWithDependencies(): void
    {
        $this->container->bind('dependency', fn() => new \stdClass());

        $resolved = $this->container->make('dependency');
        $this->assertInstanceOf(\stdClass::class, $resolved);
    }
}
