<?php

declare(strict_types=1);

namespace Tests\Core\Routing;

use Flowaxy\Core\Routing\Router;
use Flowaxy\Core\Routing\Route;
use PHPUnit\Framework\TestCase;

/**
 * Тесты для Router
 *
 * @package Tests\Core\Routing
 */
final class RouterTest extends TestCase
{
    private Router $router;

    protected function setUp(): void
    {
        $this->router = new Router();
    }

    public function testAddRoute(): void
    {
        $route = new Route('GET', '/test', fn() => 'test');
        $this->router->addRoute($route);

        $this->assertTrue($this->router->hasRoute('GET', '/test'));
    }

    public function testMatchRoute(): void
    {
        $route = new Route('GET', '/test', fn() => 'test');
        $this->router->addRoute($route);

        $matched = $this->router->match('GET', '/test');
        $this->assertNotNull($matched);
        $this->assertEquals($route, $matched);
    }

    public function testMatchRouteNotFound(): void
    {
        $matched = $this->router->match('GET', '/not-found');
        $this->assertNull($matched);
    }

    public function testMatchRouteWithParameters(): void
    {
        $route = new Route('GET', '/user/{id}', fn() => 'user');
        $this->router->addRoute($route);

        $matched = $this->router->match('GET', '/user/123');
        $this->assertNotNull($matched);
    }
}
