<?php

declare(strict_types=1);

namespace Tests\Core\Hooks;

use Flowaxy\Core\Hooks\HookManager;
use PHPUnit\Framework\TestCase;

/**
 * Тесты для HookManager
 *
 * @package Tests\Core\Hooks
 */
final class HookManagerTest extends TestCase
{
    private HookManager $hookManager;

    protected function setUp(): void
    {
        $this->hookManager = new HookManager();
    }

    public function testAddAction(): void
    {
        $this->hookManager->addAction('test_action', fn() => 'test', 10);
        $this->assertTrue($this->hookManager->hasAction('test_action'));
    }

    public function testDoAction(): void
    {
        $called = false;
        $this->hookManager->addAction('test_action', function() use (&$called) {
            $called = true;
        });

        $this->hookManager->doAction('test_action');
        $this->assertTrue($called);
    }

    public function testApplyFilter(): void
    {
        $this->hookManager->addFilter('test_filter', fn($value) => $value . '_filtered', 10);

        $result = $this->hookManager->applyFilter('test_filter', 'test');
        $this->assertEquals('test_filtered', $result);
    }

    public function testFilterPriority(): void
    {
        $this->hookManager->addFilter('test_filter', fn($value) => $value . '_1', 10);
        $this->hookManager->addFilter('test_filter', fn($value) => $value . '_2', 20);

        $result = $this->hookManager->applyFilter('test_filter', 'test');
        $this->assertStringContainsString('_1', $result);
        $this->assertStringContainsString('_2', $result);
    }
}
