<?php

declare(strict_types=1);

namespace Tests\Contracts\Cache;

use Flowaxy\Contracts\Cache\CacheInterface;
use Tests\Contracts\TestCase;

/**
 * Абстрактный тест для CacheInterface
 *
 * @package Tests\Contracts\Cache
 */
abstract class AbstractCacheInterfaceTest extends TestCase
{
    /**
     * Получить реализацию CacheInterface для тестирования
     *
     * @return CacheInterface
     */
    abstract protected function getCacheInstance(): CacheInterface;

    /**
     * Тест метода get
     */
    public function testGet(): void
    {
        $cache = $this->getCacheInstance();
        $cache->put('test_key', 'test_value', 60);
        $this->assertEquals('test_value', $cache->get('test_key'));
        $this->assertNull($cache->get('non_existent_key'));
    }

    /**
     * Тест метода put
     */
    public function testPut(): void
    {
        $cache = $this->getCacheInstance();
        $result = $cache->put('test_key', 'test_value', 60);
        $this->assertTrue($result);
        $this->assertEquals('test_value', $cache->get('test_key'));
    }

    /**
     * Тест метода forget
     */
    public function testForget(): void
    {
        $cache = $this->getCacheInstance();
        $cache->put('test_key', 'test_value', 60);
        $result = $cache->forget('test_key');
        $this->assertTrue($result);
        $this->assertNull($cache->get('test_key'));
    }

    /**
     * Тест метода flush
     */
    public function testFlush(): void
    {
        $cache = $this->getCacheInstance();
        $cache->put('test_key1', 'value1', 60);
        $cache->put('test_key2', 'value2', 60);
        $result = $cache->flush();
        $this->assertTrue($result);
        $this->assertNull($cache->get('test_key1'));
        $this->assertNull($cache->get('test_key2'));
    }

    /**
     * Тест метода has
     */
    public function testHas(): void
    {
        $cache = $this->getCacheInstance();
        $cache->put('test_key', 'test_value', 60);
        $this->assertTrue($cache->has('test_key'));
        $this->assertFalse($cache->has('non_existent_key'));
    }
}
