<?php

declare(strict_types=1);

namespace Tests\Bootstrap;

use Flowaxy\Bootstrap\ProtocolDetector;
use Tests\TestCase;

/**
 * Тесты для ProtocolDetector
 *
 * @package Tests\Bootstrap
 */
final class ProtocolDetectorTest extends TestCase
{
    /**
     * Тест определения протокола
     */
    public function testDetect(): void
    {
        $protocol = ProtocolDetector::detect();

        $this->assertIsString($protocol);
        $this->assertContains($protocol, ['http', 'https']);
    }
}
