<?php

declare(strict_types=1);

namespace Tests\Bootstrap;

use Flowaxy\Bootstrap\AutoloaderInitializer;
use Flowaxy\Core\System\Autoloader\ClassAutoloader;
use Tests\TestCase;

/**
 * Тесты для AutoloaderInitializer
 *
 * @package Tests\Bootstrap
 */
final class AutoloaderInitializerTest extends TestCase
{
    /**
     * Тест инициализации автозагрузчика
     */
    public function testInitialize(): void
    {
        $autoloader = AutoloaderInitializer::initialize(function() {
            return [];
        });

        $this->assertNotNull($autoloader);
        if ($autoloader !== null) {
            $this->assertTrue(spl_autoload_registered([$autoloader, 'load']));
        }
    }

    /**
     * Тест регистрации глобальной переменной
     */
    public function testGlobalAutoloaderVariable(): void
    {
        AutoloaderInitializer::initialize(function() {
            return [];
        });

        $this->assertArrayHasKey('engineAutoloader', $GLOBALS);
        if (isset($GLOBALS['engineAutoloader'])) {
            $this->assertIsObject($GLOBALS['engineAutoloader']);
        }
    }
}
