<?php

declare(strict_types=1);

namespace Tests\Bootstrap;

use Flowaxy\Bootstrap\Application;
use PHPUnit\Framework\TestCase;

/**
 * Тесты для Application
 *
 * @package Tests\Bootstrap
 */
final class ApplicationTest extends TestCase
{
    public function testApplicationIsFinal(): void
    {
        $reflection = new \ReflectionClass(Application::class);
        $this->assertTrue($reflection->isFinal());
    }

    public function testApplicationHasRunMethod(): void
    {
        $this->assertTrue(method_exists(Application::class, 'run'));
    }

    public function testApplicationIsUnder120Lines(): void
    {
        $file = new \SplFileObject(__DIR__ . '/../../flowaxy/Bootstrap/Application.php');
        $lineCount = 0;
        while (!$file->eof()) {
            $file->current();
            $lineCount++;
            $file->next();
        }
        $this->assertLessThan(120, $lineCount, 'Application.php должен быть меньше 120 строк');
    }

    public function testApplicationUsesOnlyInterfaces(): void
    {
        $content = file_get_contents(__DIR__ . '/../../flowaxy/Bootstrap/Application.php');

        // Проверяем, что нет прямых зависимостей от реализаций
        $this->assertStringNotContainsString('use Flowaxy\\Infrastructure\\', $content);
        $this->assertStringNotContainsString('use Flowaxy\\Core\\System\\Container\\Container;', $content);
    }

    public function testApplicationNoRequireOnce(): void
    {
        $content = file_get_contents(__DIR__ . '/../../flowaxy/Bootstrap/Application.php');
        $this->assertStringNotContainsString('require_once', $content);
    }
}
