<?php

/**
 * Глобальные функции-хелперы для работы с темами
 * Используются в шаблонах тем для упрощенного доступа к API темы
 *
 * @package Flowaxy\Support\Helpers
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

// Функции должны быть глобальными, без namespace

/**
 * Рендеринг компонента темы
 *
 * @param string $name Имя компонента
 * @param array<string, mixed> $props Свойства компонента
 * @param bool $return Возвращать результат вместо вывода
 * @return string|void
 */
if (!function_exists('theme_component')) {
    function theme_component(string $name, array $props = [], bool $return = false)
    {
        if (class_exists('\Flowaxy\Support\Theme\Theme')) {
            return \Flowaxy\Support\Theme\Theme::component($name, $props, $return);
        }
        if ($return) {
            return '';
        }
    }
}

/**
 * Получение URL asset темы
 *
 * @param string $path Относительный путь к asset
 * @param bool $versioning Добавлять версию для cache busting
 * @return string
 */
if (!function_exists('theme_asset')) {
    function theme_asset(string $path, bool $versioning = true): string
    {
        if (class_exists('\Flowaxy\Support\Theme\Theme')) {
            return \Flowaxy\Support\Theme\Theme::asset($path, $versioning);
        }
        return '';
    }
}
