<?php

/**
 * Глобальные функции-хелперы для работы с путями
 *
 * @package Flowaxy\Support\Helpers
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

// PathResolver должен быть загружен до этого файла
use Flowaxy\Core\System\PathResolver;

if (!function_exists('path_root')) {
    /**
     * Получить корень проекта
     *
     * @return string
     */
    function path_root(): string
    {
        return PathResolver::root();
    }
}

if (!function_exists('path_engine')) {
    /**
     * Получить путь к ядру системы
     *
     * @return string
     */
    function path_engine(): string
    {
        return PathResolver::engine();
    }
}

if (!function_exists('path_plugins')) {
    /**
     * Получить путь к плагинам
     *
     * @return string
     */
    function path_plugins(): string
    {
        return PathResolver::plugins();
    }
}

if (!function_exists('path_plugin')) {
    /**
     * Получить путь к конкретному плагину
     *
     * @param string $pluginSlug
     * @return string
     */
    function path_plugin(string $pluginSlug): string
    {
        return PathResolver::plugin($pluginSlug);
    }
}

if (!function_exists('path_themes')) {
    /**
     * Получить путь к темам
     *
     * @return string
     */
    function path_themes(): string
    {
        return PathResolver::themes();
    }
}

if (!function_exists('path_theme')) {
    /**
     * Получить путь к конкретной теме
     *
     * @param string $themeSlug
     * @return string
     */
    function path_theme(string $themeSlug): string
    {
        return PathResolver::theme($themeSlug);
    }
}

if (!function_exists('path_storage')) {
    /**
     * Получить путь к storage
     *
     * @return string
     */
    function path_storage(): string
    {
        return PathResolver::storage();
    }
}

if (!function_exists('path_cache')) {
    /**
     * Получить путь к кешу
     *
     * @return string
     */
    function path_cache(): string
    {
        return PathResolver::cache();
    }
}

if (!function_exists('path_logs')) {
    /**
     * Получить путь к логам
     *
     * @return string
     */
    function path_logs(): string
    {
        return PathResolver::logs();
    }
}

if (!function_exists('path_uploads')) {
    /**
     * Получить путь к uploads
     *
     * @return string
     */
    function path_uploads(): string
    {
        return PathResolver::uploads();
    }
}

if (!function_exists('path_sessions')) {
    /**
     * Получить путь к сессиям
     *
     * @return string
     */
    function path_sessions(): string
    {
        return PathResolver::sessions();
    }
}

if (!function_exists('path_storage_config')) {
    /**
     * Получить путь к конфигурации storage
     *
     * @return string
     */
    function path_storage_config(): string
    {
        return PathResolver::storageConfig();
    }
}

if (!function_exists('path_core')) {
    /**
     * Получить путь к core директории
     *
     * @return string
     */
    function path_core(): string
    {
        return PathResolver::core();
    }
}

if (!function_exists('path_bootstrap')) {
    /**
     * Получить путь к bootstrap
     *
     * @return string
     */
    function path_bootstrap(): string
    {
        return PathResolver::bootstrap();
    }
}

if (!function_exists('path_config')) {
    /**
     * Получить путь к config
     *
     * @return string
     */
    function path_config(): string
    {
        return PathResolver::storageConfig();
    }
}

if (!function_exists('path_content')) {
    /**
     * Получить путь к content/
     *
     * @return string
     */
    function path_content(): string
    {
        return PathResolver::content();
    }
}

if (!function_exists('path_content_admin')) {
    /**
     * Получить путь к content/admin/
     *
     * @return string
     */
    function path_content_admin(): string
    {
        return PathResolver::contentAdmin();
    }
}

if (!function_exists('path_content_assets')) {
    /**
     * Получить путь к content/admin/resources/
     *
     * @return string
     */
    function path_content_assets(): string
    {
        return PathResolver::contentAssets();
    }
}

if (!function_exists('path_flowaxy')) {
    /**
     * Получить путь к flowaxy/ (ядро фреймворка)
     *
     * @return string
     */
    function path_flowaxy(): string
    {
        return PathResolver::flowaxy();
    }
}

if (!function_exists('path_modules')) {
    /**
     * Получить путь к modules/
     *
     * @return string
     */
    function path_modules(): string
    {
        return PathResolver::modules();
    }
}

if (!function_exists('path_external_modules')) {
    /**
     * Получить путь к externalModules/
     *
     * @return string
     */
    function path_external_modules(): string
    {
        return PathResolver::externalModules();
    }
}

if (!function_exists('path_join')) {
    /**
     * Построить путь относительно корня
     *
     * @param string ...$parts
     * @return string
     */
    function path_join(string ...$parts): string
    {
        return PathResolver::join(...$parts);
    }
}
