<?php

declare(strict_types=1);

use Flowaxy\Support\Helpers\ComponentHelper;

// Глобальные функции-хелперы для работы с контентом
// Интерфейс общения между фреймворком и контентом

// Рендеринг компонента
// Обертка над getComponent для удобства использования в контенте
if (!function_exists('render_component')) {
    function render_component(string $name, array $config = []): string
    {
        if (function_exists('getComponent')) {
            return getComponent($name, $config);
        }

        return '';
    }
}

// Рендеринг шаблона
// Обертка над getTemplate для удобства использования в контенте
if (!function_exists('render_template')) {
    function render_template(string $name, array $data = []): string
    {
        if (function_exists('getTemplate')) {
            return getTemplate($name, $data);
        }

        return '';
    }
}

// Получение данных через хуки
// Удобная функция для получения данных страниц через фильтры
if (!function_exists('get_content_data')) {
    function get_content_data(string $hook, array $default = []): array
    {
        if (function_exists('applyFilter')) {
            // @phpstan-ignore-next-line - applyFilter() is a global function
            $data = \applyFilter($hook, $default);
            return is_array($data) ? $data : $default;
        } elseif (function_exists('hooks')) {
            // @phpstan-ignore-next-line - hooks() is a global function
            $data = \hooks()->apply($hook, $default);
            return is_array($data) ? $data : $default;
        }

        return $default;
    }
}
