<?php

/**
 * Хелпер для роботи зі стилями адмін-панелі
 * Без автокомпіляції SCSS під час HTTP-запитів (компіляція виконується через CLI)
 *
 * @package Flowaxy\Support\Helpers
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Support\Helpers;

use Flowaxy\Infrastructure\Compilers\AdminScssCompiler;
use Throwable;

final class AdminStyleHelper
{
    private static ?AdminScssCompiler $compiler = null;

    /**
     * Отримати URL до стилів адмінки (без автокомпіляції SCSS)
     *
     * @return string URL до CSS файлу
     */
    public static function getStylesheetUrl(): string
    {
        $compiler = self::getCompiler();

        return $compiler->getCssUrl();
    }

    /**
     * Отримати екземпляр компілятора
     *
     * @return AdminScssCompiler
     */
    private static function getCompiler(): AdminScssCompiler
    {
        if (self::$compiler === null) {
            self::$compiler = new AdminScssCompiler();
        }

        return self::$compiler;
    }

    /**
     * Примусова компіляція SCSS
     *
     * @return bool
     */
    public static function compileScss(): bool
    {
        $compiler = self::getCompiler();

        if (!$compiler->hasScssFiles()) {
            return false;
        }

        try {
            $result = $compiler->compile(true);
            if (!$result) {
                error_log("AdminStyleHelper: Компіляція SCSS повернула false");
            }
            return $result;
        } catch (Throwable $e) {
            error_log("AdminStyleHelper: Помилка примусової компіляції SCSS адмінки: " . $e->getMessage() . " in " . $e->getFile() . ":" . $e->getLine());
            return false;
        }
    }

    /**
     * Перевірка, чи потрібна компіляція
     *
     * @return bool
     */
    public static function needsCompilation(): bool
    {
        $compiler = self::getCompiler();

        if (!$compiler->hasScssFiles()) {
            return false;
        }

        return !$compiler->isUpToDate();
    }
}
