<?php

/**
 * Фасад для роботи з YAML
 *
 * @package Flowaxy\Support\Facades
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Support\Facades;

use Flowaxy\Infrastructure\Filesystem\Yaml as YamlInstance;
use Flowaxy\Support\Helpers\YamlHelper;

final class Yaml extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return YamlInstance::class;
    }

    /**
     * Парсити YAML рядок
     *
     * @param string $yaml
     * @param int $flags
     * @return mixed
     */
    public static function parse(string $yaml, int $flags = 0): mixed
    {
        return YamlHelper::parse($yaml, $flags);
    }

    /**
     * Генерувати YAML з даних
     *
     * @param mixed $data
     * @param int $indent
     * @param int $flags
     * @return string|false
     */
    public static function dump(mixed $data, int $indent = 2, int $flags = 0): string|false
    {
        return YamlHelper::dump($data, $indent, $flags);
    }

    /**
     * Прочитати YAML з файлу
     *
     * @param string $path
     * @param int $flags
     * @return mixed|false
     */
    public static function readFile(string $path, int $flags = 0): mixed
    {
        return YamlHelper::readFile($path, $flags);
    }

    /**
     * Записати YAML у файл
     *
     * @param string $path
     * @param mixed $data
     * @param int $indent
     * @param int $flags
     * @return bool
     */
    public static function writeFile(string $path, mixed $data, int $indent = 2, int $flags = 0): bool
    {
        return YamlHelper::writeFile($path, $data, $indent, $flags);
    }

    /**
     * Перевірити, чи рядок є валідним YAML
     *
     * @param string $yaml
     * @return bool
     */
    public static function isValid(string $yaml): bool
    {
        return YamlHelper::isValid($yaml);
    }

    /**
     * Об'єднати YAML дані
     *
     * @param mixed ...$data
     * @return array<string, mixed>|false
     */
    public static function merge(mixed ...$data): array|false
    {
        return YamlHelper::merge(...$data);
    }
}
