<?php

/**
 * Фасад для роботи з темами
 *
 * @package Flowaxy\Support\Facades
 */

declare(strict_types=1);

namespace Flowaxy\Support\Facades;

use Flowaxy\Support\Managers\ThemeManager;

final class Theme extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return ThemeManager::class;
    }

    /**
     * Отримання менеджера тем
     */
    public static function manager(): ThemeManager
    {
        $container = static::getContainer();
        if ($container->has(ThemeManager::class)) {
            return $container->make(ThemeManager::class);
        }

        // Fallback на getInstance
        return ThemeManager::getInstance();
    }
}
