<?php

/**
 * Фасад для роботи з налаштуваннями
 *
 * @package Flowaxy\Support\Facades
 */

declare(strict_types=1);

namespace Flowaxy\Support\Facades;

use Flowaxy\Support\Managers\SettingsManager;

final class Settings extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return SettingsManager::class;
    }

    /**
     * Отримання менеджера налаштувань
     */
    public static function manager(): ?SettingsManager
    {
        try {
            $root = static::getFacadeRoot();
            // Якщо повернуто Closure, викликаємо його
            if ($root instanceof \Closure) {
                $root = $root();
            }
            // Перевіряємо, чи це SettingsManager
            if ($root instanceof SettingsManager) {
                return $root;
            }
            return null;
        } catch (\RuntimeException $e) {
            return null;
        }
    }

    /**
     * Отримання значення налаштування
     */
    public static function get(string $key, mixed $default = null): mixed
    {
        $manager = static::manager();
        if ($manager === null) {
            return $default;
        }

        return $manager->get($key, $default);
    }

    /**
     * Встановлення значення налаштування
     */
    public static function set(string $key, mixed $value): void
    {
        $manager = static::manager();
        if ($manager !== null) {
            $manager->set($key, $value);
        }
    }

    /**
     * Перевірка наявності налаштування
     */
    public static function has(string $key): bool
    {
        $manager = static::manager();
        if ($manager === null) {
            return false;
        }

        return $manager->has($key);
    }
}
