<?php

/**
 * Фасад для роботи з ролями та правами
 *
 * @package Flowaxy\Support\Facades
 */

declare(strict_types=1);

namespace Flowaxy\Support\Facades;

use Flowaxy\Support\Managers\RoleManager;

final class Role extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return RoleManager::class;
    }

    /**
     * Отримання менеджера ролей
     */
    public static function manager(): RoleManager
    {
        $container = static::getContainer();
        if ($container->has(RoleManager::class)) {
            $result = $container->make(RoleManager::class);
            // Якщо контейнер повернув Closure, викликаємо його
            if ($result instanceof \Closure) {
                $result = $result();
            }
            // Перевіряємо, що отримали правильний об'єкт
            if ($result instanceof RoleManager) {
                return $result;
            }
        }

        // Fallback на getInstance
        return RoleManager::getInstance();
    }

    /**
     * Перевірка дозволу у користувача
     */
    public static function userCan(int $userId, string $permission): bool
    {
        if (function_exists('user_can')) {
            return user_can($userId, $permission);
        }

        return static::manager()->hasPermission($userId, $permission);
    }

    /**
     * Перевірка ролі у користувача
     */
    public static function userHasRole(int $userId, string $roleSlug): bool
    {
        if (function_exists('user_has_role')) {
            return user_has_role($userId, $roleSlug);
        }

        return static::manager()->hasRole($userId, $roleSlug);
    }
}
