<?php

/**
 * Фасад для роботи з обмеженням запитів
 *
 * @package Flowaxy\Support\Facades
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Support\Facades;

use Flowaxy\Infrastructure\Security\RateLimiter as RateLimiterInstance;

final class RateLimiter extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return RateLimiterInstance::class;
    }

    /**
     * Отримати екземпляр RateLimiter
     *
     * @return RateLimiterInstance
     */
    private static function limiter(): RateLimiterInstance
    {
        return static::getFacadeRoot();
    }

    /**
     * Перевірити, чи перевищено ліміт
     *
     * @param string|null $identifier
     * @return bool
     */
    public static function isLimited(?string $identifier = null): bool
    {
        return static::limiter()->isLimited($identifier);
    }

    /**
     * Отримати поточний лічильник
     *
     * @param string|null $identifier
     * @return int
     */
    public static function getCurrentCount(?string $identifier = null): int
    {
        return static::limiter()->getCurrentCount($identifier);
    }

    /**
     * Отримати залишковий час до скидання
     *
     * @param string|null $identifier
     * @return int
     */
    public static function getRemainingTime(?string $identifier = null): int
    {
        return static::limiter()->getRemainingTime($identifier);
    }

    /**
     * Скинути ліміт
     *
     * @param string|null $identifier
     * @return void
     */
    public static function reset(?string $identifier = null): void
    {
        static::limiter()->reset($identifier);
    }
}
