<?php

/**
 * Фасад для роботи з поштою
 *
 * @package Flowaxy\Support\Facades
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Support\Facades;

use Flowaxy\Infrastructure\Mail\Mail as MailInstance;

final class Mail extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return MailInstance::class;
    }

    /**
     * Створити новий екземпляр Mail (builder pattern)
     *
     * @return MailInstance
     */
    private static function create(): MailInstance
    {
        return new MailInstance();
    }

    /**
     * Відправити лист
     *
     * @param string|array<int, string> $to
     * @param string $subject
     * @param string $body
     * @param bool $isHtml
     * @return bool
     */
    public static function send(string|array $to, string $subject, string $body, bool $isHtml = true): bool
    {
        return static::create()
            ->to($to)
            ->subject($subject)
            ->body($body, $isHtml)
            ->send();
    }

    /**
     * Додати лист в чергу (alias для send, так як черга не реалізована)
     *
     * @param string|array<int, string> $to
     * @param string $subject
     * @param string $body
     * @param bool $isHtml
     * @return bool
     */
    public static function queue(string|array $to, string $subject, string $body, bool $isHtml = true): bool
    {
        // Поки що черга не реалізована, просто відправляємо
        return static::send($to, $subject, $body, $isHtml);
    }

    /**
     * Створити новий екземпляр Mail
     *
     * @return MailInstance
     */
    public static function make(): MailInstance
    {
        return static::create();
    }
}
